package de.beagtex.listener.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.undo.CannotRedoException;

import de.beagtex.gui.Editor;

/**
 * Listener for redo-actions
 * 
 * @author Benjamin Haag
 */
public class RedoListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor-object
	 */
	public RedoListener(Editor editor) {

		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		try {
			editor.redoAction.actionPerformed(arg0);
		} catch (CannotRedoException e) {
			System.err.println("No more redos possible");
		}
	}

}
