package de.beagtex.listener.control;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import de.beagtex.gui.BFrame;
import de.beagtex.gui.Editor;
import de.beagtex.listener.format.BoldListener;
import de.beagtex.listener.format.CenteredListener;
import de.beagtex.listener.format.ColordefListener;
import de.beagtex.listener.format.ItalicListener;
import de.beagtex.listener.format.LeftListener;
import de.beagtex.listener.format.RightListener;
import de.beagtex.listener.format.StandardColordefListener;
import de.beagtex.listener.format.UnderlineListener;
import de.beagtex.listener.insert.AutoIndexListener;
import de.beagtex.listener.insert.BulletListener;
import de.beagtex.listener.insert.CaptionAboveListener;
import de.beagtex.listener.insert.CaptionListener;
import de.beagtex.listener.insert.ChangeoverListener;
import de.beagtex.listener.insert.ContentListener;
import de.beagtex.listener.insert.CrossRefLabelListener;
import de.beagtex.listener.insert.CrossRefPagereferenceListener;
import de.beagtex.listener.insert.CrossRefReferenceListener;
import de.beagtex.listener.insert.EmptyPageListener;
import de.beagtex.listener.insert.FigureListener;
import de.beagtex.listener.insert.FootnoteListener;
import de.beagtex.listener.insert.GraphicListener;
import de.beagtex.listener.insert.IndexInsertListener;
import de.beagtex.listener.insert.IndexingListerner;
import de.beagtex.listener.insert.LatexListener;
import de.beagtex.listener.insert.MarginNoteListener;
import de.beagtex.listener.insert.NumberedListener;
import de.beagtex.listener.insert.QuotationListener;
import de.beagtex.listener.insert.TableListListener;
import de.beagtex.listener.insert.TableListener;

/**
 * Mouse-Listener; used for context-menu with right-click
 * 
 * @author Benjamin Haag
 */
public class MyMouseListener implements MouseListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor-object
	 */
	public MyMouseListener(Editor editor) {

		this.editor = editor;
	}

	/*
	 * (Kein Javadoc)
	 * 
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 */
	public void mouseClicked(MouseEvent arg0) {

	}

	public void mousePressed(MouseEvent mausi) {

		if (mausi.getButton() == 3) {

			JPopupMenu poppy = new JPopupMenu();

			JMenuItem popUndo = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.edit.undo"));
			popUndo.addActionListener(new UndoListener(editor));
			JMenuItem popRedo = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.edit.redo"));
			popRedo.addActionListener(new RedoListener(editor));
			JMenuItem popCopy = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.edit.copy"));
			popCopy.addActionListener(new CopyListener(editor));
			JMenuItem popPaste = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.edit.paste"));
			popPaste.addActionListener(new PasteListener(editor));
			JMenuItem popCut = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.edit.cut"));
			popCut.addActionListener(new CutListener(editor));
			JMenuItem popSave = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.file.save"));
			popSave.addActionListener(new SaveListener(editor));
			JMenuItem popSaveAs = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.file.saveas"));
			popSaveAs.addActionListener(new SaveAsListener(editor));

			// Format-Menu
			JMenu format = new JMenu(BFrame.get_prop().getProperty(
					"beagtex.menu.format"));
			JMenuItem fett = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.format.bold"));
			fett.addActionListener(new BoldListener(editor));
			JMenuItem kursiv = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.format.italic"));
			kursiv.addActionListener(new ItalicListener(editor));
			JMenuItem unterstrichen = new JMenuItem(BFrame.get_prop()
					.getProperty("beagtex.menu.format.underline"));
			unterstrichen.addActionListener(new UnderlineListener(editor));
			JMenu ausrichtung = new JMenu(BFrame.get_prop().getProperty(
					"beagtex.menu.format.alignment"));
			JMenuItem links = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.format.alignment.left"));
			links.addActionListener(new LeftListener(editor));
			JMenuItem mitte = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.format.alignment.centered"));
			mitte.addActionListener(new CenteredListener(editor));
			JMenuItem rechts = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.format.alignment.right"));
			rechts.addActionListener(new RightListener(editor));
			JMenuItem farbdef = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.format.colordef"));
			farbdef.addActionListener(new ColordefListener(editor));
			JMenuItem indiz = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.format.indexing"));
			indiz.addActionListener(new IndexingListerner(editor));
			JMenuItem autoIndiz = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.format.autoindexing"));
			autoIndiz.addActionListener(new AutoIndexListener(editor));

			format.add(fett);
			format.add(kursiv);
			format.add(unterstrichen);
			ausrichtung.add(links);
			ausrichtung.add(mitte);
			ausrichtung.add(rechts);
			// setContentPane(ausrichtung);
			format.add(ausrichtung);
			format.add(farbdef);
			format.add(indiz);
			format.add(autoIndiz);
			// setContentPane(format);

			// Insert-Menu
			JMenu insert = new JMenu(BFrame.get_prop().getProperty(
					"beagtex.menu.insert"));
			JMenu wechsel = new JMenu(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.manualchangeover"));
			JMenuItem seitenwechsel = new JMenuItem(BFrame.get_prop()
					.getProperty(
							"beagtex.menu.insert.manualchangeover.changeover"));
			seitenwechsel.addActionListener(new ChangeoverListener(editor));
			JMenuItem leerseite = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.manualchangeover.emptypage"));
			leerseite.addActionListener(new EmptyPageListener(editor));
			wechsel.add(seitenwechsel);
			wechsel.add(leerseite);
			JMenu grafik = new JMenu(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.graphics"));
			JMenuItem grafikIn = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.graphics.insert"));
			grafikIn.addActionListener(new GraphicListener(editor));
			JMenu grafBeschriftung = new JMenu(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.graphics.caption"));
			JMenuItem grafBeschriftOben = new JMenuItem(BFrame.get_prop()
					.getProperty("beagtex.menu.insert.graphics.caption.above"));
			grafBeschriftOben
					.addActionListener(new CaptionAboveListener(editor));
			JMenuItem grafBeschriftUnten = new JMenuItem(BFrame.get_prop()
					.getProperty("beagtex.menu.insert.graphics.caption.beneath"));
			grafBeschriftUnten.addActionListener(new CaptionListener(editor));
			grafBeschriftung.add(grafBeschriftOben);
			grafBeschriftung.add(grafBeschriftUnten);
			grafik.add(grafikIn);
			grafik.add(grafBeschriftung);
			JMenu tabelle = new JMenu(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.table"));
			JMenuItem tabelleIn = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.table.insert"));
			tabelleIn.addActionListener(new TableListener(editor));
			JMenu tabBeschriftung = new JMenu(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.table.caption"));
			JMenuItem tabBeschriftOben = new JMenuItem(BFrame.get_prop()
					.getProperty("beagtex.menu.insert.table.caption.above"));
			tabBeschriftOben
					.addActionListener(new CaptionAboveListener(editor));
			JMenuItem tabBeschriftUnten = new JMenuItem(BFrame.get_prop()
					.getProperty("beagtex.menu.insert.table.caption.beneath"));
			tabBeschriftUnten.addActionListener(new CaptionListener(editor));
			tabBeschriftung.add(tabBeschriftOben);
			tabBeschriftung.add(tabBeschriftUnten);
			tabelle.add(tabelleIn);
			tabelle.add(tabBeschriftung);
			JMenuItem zitat = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.quotation"));
			zitat.addActionListener(new QuotationListener(editor));
			JMenuItem latex = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.latexfile"));
			latex.addActionListener(new LatexListener(editor));
			JMenu aufzaehlung = new JMenu(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.listings"));
			JMenuItem standard = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.listings.standard"));
			standard.addActionListener(new BulletListener(editor));
			JMenuItem nummeriert = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.listings.numbered"));
			nummeriert.addActionListener(new NumberedListener(editor));
			JMenuItem fussnote = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.footnote"));
			fussnote.addActionListener(new FootnoteListener(editor));
			JMenuItem standardFarben = new JMenuItem(BFrame.get_prop()
					.getProperty("beagtex.menu.insert.standardcolordef"));
			standardFarben.addActionListener(new StandardColordefListener(
					editor));
			aufzaehlung.add(standard);
			aufzaehlung.add(nummeriert);
			JMenu registers = new JMenu(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.registers"));
			JMenuItem inhalt = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.registers.toc"));
			inhalt.addActionListener(new ContentListener(editor));
			JMenuItem abbildungen = new JMenuItem(BFrame.get_prop()
					.getProperty("beagtex.menu.insert.registers.lof"));
			abbildungen.addActionListener(new FigureListener(editor));
			JMenuItem tabellen = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.registers.lof"));
			tabellen.addActionListener(new TableListListener(editor));
			JMenuItem index = new JMenuItem(BFrame.get_prop().getProperty(
					"beagtex.menu.insert.registers.index"));
			index.addActionListener(new IndexInsertListener(editor));
			registers.add(inhalt);
			registers.add(abbildungen);
			registers.add(tabellen);
			registers.add(index);
			
			JMenuItem marginnote = new JMenuItem(BFrame.get_prop().getProperty(
			 "beagtex.menu.insert.marginnote"));
			marginnote.addActionListener(new MarginNoteListener(editor));
			
			JMenu crossref = new JMenu(BFrame.get_prop().getProperty(
			 "beagtex.menu.insert.crossref"));
			JMenuItem label = new JMenuItem(BFrame.get_prop().getProperty(
			 "beagtex.menu.insert.crossref.label"));
			label.addActionListener(new CrossRefLabelListener(editor));
			JMenuItem reference = new JMenuItem(BFrame.get_prop().getProperty(
			 "beagtex.menu.insert.crossref.reference"));
			reference.addActionListener(new CrossRefReferenceListener(editor));
			JMenuItem pagereference = new JMenuItem(BFrame.get_prop().getProperty(
			 "beagtex.menu.insert.crossref.pagereference"));
			pagereference.addActionListener(new CrossRefPagereferenceListener(editor));
			crossref.add(label);
			crossref.add(reference);
			crossref.add(pagereference);
			
			insert.add(wechsel);
			insert.add(grafik);
			insert.add(tabelle);
			insert.add(zitat);
			insert.add(latex);
			insert.add(aufzaehlung);
			insert.add(fussnote);
			insert.add(standardFarben);
			insert.add(registers);
			insert.add(marginnote);
			insert.add(crossref);

			poppy.add(popUndo);
			poppy.add(popRedo);
			poppy.addSeparator();
			poppy.add(popCopy);
			poppy.add(popPaste);
			poppy.add(popCut);
			poppy.addSeparator();
			poppy.add(popSave);
			poppy.add(popSaveAs);
			poppy.addSeparator();
			poppy.add(format);
			poppy.add(insert);

			poppy.show(editor, mausi.getX(), mausi.getY());
		}
	}

	/*
	 * (Kein Javadoc)
	 * 
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 */
	public void mouseReleased(MouseEvent arg0) {

	}

	/*
	 * (Kein Javadoc)
	 * 
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 */
	public void mouseEntered(MouseEvent arg0) {

	}

	/*
	 * (Kein Javadoc)
	 * 
	 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
	 */
	public void mouseExited(MouseEvent arg0) {

	}

}
