package de.beagtex.listener.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import de.beagtex.gui.BFrame;
import de.beagtex.gui.Editor;

/**
 * Listener for closing; if not saved yet, a PopUp appears and asks for it.
 * Editor.number will be decremented
 * 
 * @author Benjamin Haag
 */
public class ExitListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param pEditor:
	 *            the calling editor-object
	 */
	public ExitListener(Editor pEditor) {

		this.editor = pEditor;
	}

	public void actionPerformed(ActionEvent e) {

		String test = editor.getText();
		if (!test.equalsIgnoreCase("")) {
			editor.setVisible(false);
			Editor.decrementNumber();
			if (editor.isSaved() != true) {

				if (JOptionPane
						.showConfirmDialog(
								null,
								BFrame.get_prop().getProperty(
										"beagtex.exitlistener.saveconfirm"),
								BFrame
										.get_prop()
										.getProperty(
												"beagtex.exitlistener.saveconfirmtitle"),
								JOptionPane.YES_NO_OPTION,
								JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION)
					editor.saveAs();
			}
			if (Editor.getNumber() == 0)
				System.exit(0);
		} else {
			editor.setVisible(false);
			Editor.decrementNumber();
			if (Editor.getNumber() == 0)
				System.exit(0);
		}
	}
}
