package de.beagtex.gui;

import java.awt.Container;
import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import de.beagtex.listener.gui.TabCancelListener;
import de.beagtex.listener.gui.TabOkListener;

/**
 * Supportwindow, where the User can input the wanted numbers of lines and
 * columns; will be tranlsated into LaTex-Code
 * 
 * @author Benjamin Haag
 * 
 */
public class TableCreateWindow extends BWindow {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	Editor editor;

	JLabel columnL;
	JLabel lineL;
	public JTextField columnTF;
	public JTextField lineTF;
	JButton okB;
	JButton cancelB;
	JPanel newTableP;
	JPanel buttonsP;
	JPanel checkLabelP;
	JPanel checkBoxP;
	public JCheckBox verticalCB;
	JLabel verticalL;
	JLabel horizontalL;
	public JCheckBox horizontalCB;
	Container conty;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public TableCreateWindow(Editor editor) {

		this.editor = editor;
		paint();
	}

	/**
	 * Paints the window
	 */
	public void paint() {
		setTitle(BFrame.get_prop().getProperty("beagtex.tablecreate.title"));
		setResizable(false);

		conty = new Container();
		newTableP = new JPanel();
		newTableP.setLayout(new GridLayout(2, 2, 5, 5));
		buttonsP = new JPanel();
		buttonsP.setLayout(new GridLayout(2, 1, 5, 5));
		checkLabelP = new JPanel();
		checkLabelP.setLayout(new GridLayout(2, 1));
		checkBoxP = new JPanel();
		checkBoxP.setLayout(new GridLayout(2, 1));

		conty.setLayout(new GridLayout(2, 2, 70, 20));

		columnL = new JLabel(" "
				+ BFrame.get_prop().getProperty(
						"beagtex.tablecreate.columnlabel") +"  ");
		columnTF = new JTextField(3);

		lineL = new JLabel(" " + BFrame.get_prop().getProperty("beagtex.tablecreate.linelabel") +"      ");
		lineTF = new JTextField(3);

		okB = new JButton(BFrame.get_prop().getProperty("beagtex.tablecreate.okbutton"));
		// if (isTab)
		// okB.addActionListener(new TabOkListener(this, tab));
		// else
		okB.addActionListener(new TabOkListener(this, editor));
		cancelB = new JButton(BFrame.get_prop().getProperty("beagtex.tablecreate.cancelbutton"));
		cancelB.addActionListener(new TabCancelListener(this));

		verticalL = new JLabel("        " + BFrame.get_prop().getProperty("beagtex.tablecreate.verticallabel"));
		verticalCB = new JCheckBox();

		horizontalL = new JLabel("   " +BFrame.get_prop().getProperty("beagtex.tablecreate.horizontallabel"));
		horizontalCB = new JCheckBox();

		newTableP.add(columnTF);
		newTableP.add(columnL);
		newTableP.add(lineTF);
		newTableP.add(lineL);
		buttonsP.add(okB);
		buttonsP.add(cancelB);
		checkLabelP.add(verticalL);
		checkLabelP.add(horizontalL);
		checkBoxP.add(verticalCB);
		checkBoxP.add(horizontalCB);
		conty.add(newTableP);
		conty.add(buttonsP);
		conty.add(checkLabelP);
		conty.add(checkBoxP);
		getContentPane().add(conty);
	}
}
