/*
 * Decompiled with CFR 0.152.
 */
package de.beagtex.listener.gui;

import de.beagtex.gui.Editor;
import de.beagtex.gui.FormatFileWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;

public class FormatFileOkListener
implements ActionListener {
    Editor editor;
    FormatFileWindow formwindow;

    public FormatFileOkListener(FormatFileWindow pFormwindow, Editor pEditor) {
        this.formwindow = pFormwindow;
        this.editor = pEditor;
    }

    public void actionPerformed(ActionEvent e) {
        this.formwindow.setVisible(false);
        this.editor.insert("\\documentclass[a4paper, " + this.getSize() + "pt]{" + this.getStyle() + "}" + "\r\n" + this.getUsepackeges() + this.getPagestle() + this.getIndentation() + this.getGap() + this.getTopEdge() + this.getLeftEdge() + this.getTextblockWidth() + this.getTextblockHeight(), this.editor.getCaretPosition());
    }

    public int getSize() {
        int index;
        int size = index = this.formwindow.textCoB.getSelectedIndex();
        switch (index) {
            case 0: {
                size = 8;
                break;
            }
            case 1: {
                size = 10;
                break;
            }
            case 2: {
                size = 12;
                break;
            }
            case 3: {
                size = 14;
                break;
            }
            case 4: {
                size = 16;
                break;
            }
            case 5: {
                size = 18;
            }
        }
        return size;
    }

    public String getStyle() {
        String style = null;
        if (this.formwindow.articleRB.isSelected()) {
            style = "scrartcl";
        } else if (this.formwindow.bookRB.isSelected()) {
            style = "scrbook";
        } else if (this.formwindow.reportRB.isSelected()) {
            style = "scrreprt";
        } else if (this.formwindow.letterRB.isSelected()) {
            style = "scrlttr2";
        }
        return style;
    }

    public String getUsepackeges() {
        String usepackages = null;
        usepackages = this.formwindow.standardPackCB.isSelected() ? "\\usepackage[T1]{fontenc}\r\n\\usepackage[latin1]{inputenc}\r\n\\usepackage{ngerman}\r\n\\usepackage{pifont}\r\n\\usepackage{amsmath}\r\n\\usepackage[right]{eurosym}\r\n\\usepackage{scrpage2}\r\n\\usepackage{graphicx}\r\n\\usepackage{color}\r\n\\usepackage{makeidx}\r\n\\makeindex\r\n" : "";
        return usepackages;
    }

    public String getPagestle() {
        String pageStyle = null;
        pageStyle = this.formwindow.pageStyleCB.isSelected() ? "\\pagestyle{scrheadings}\r\n" : "%\\pagestyle{scrheadings}\r\n";
        return pageStyle;
    }

    public String getIndentation() {
        String indent = null;
        indent = this.formwindow.absEinrueckCB.isSelected() ? "\\setlength{\\parindent}{1em}\r\n" : "%\\setlength{\\parindent}{1em}\r\n";
        return indent;
    }

    public String getGap() {
        String gap = null;
        gap = this.formwindow.absAbstCB.isSelected() ? "\\setlength{\\parskip}{2.0ex plus 1.0ex minus 0.5ex}\r\n" : "%\\setlength{\\parskip}{2.0ex plus 1.0ex minus 0.5ex}\r\n";
        return gap;
    }

    public String getTopEdge() {
        String topEdge = null;
        int rOben = 0;
        try {
            rOben = Integer.parseInt(this.formwindow.topEdgeTF.getText());
        }
        catch (NumberFormatException e) {
            System.err.println("Insert-Error");
            JOptionPane.showMessageDialog(null, "The inserted values are not correct! All edges are initialized with 0.  \r\nYou can change these values in the format-file.", "Incorrect insert", 2);
        }
        topEdge = rOben == 0 ? "%\\setlength{\\topmargin}{" + rOben + "mm}" + "\r\n" : "\\setlength{\\topmargin}{" + rOben + "mm}" + "\r\n";
        return topEdge;
    }

    public String getLeftEdge() {
        String leftEdge = null;
        int rLinks = 0;
        try {
            rLinks = Integer.parseInt(this.formwindow.leftEdgeTF.getText());
        }
        catch (NumberFormatException e) {
            System.err.println("Insert-Error");
            JOptionPane.showMessageDialog(null, "The inserted values are not correct! All edges are initialized with 0.  \r\nYou can change these values in the format-file.", "Incorrect insert", 2);
        }
        leftEdge = rLinks == 0 ? "%\\setlength{\\oddsidemargin}{" + rLinks + "mm}" + "\r\n" : "\\setlength{\\oddsidemargin}{" + rLinks + "mm}" + "\r\n";
        return leftEdge;
    }

    public String getTextblockWidth() {
        String textblockwidth = null;
        int width = 0;
        try {
            width = Integer.parseInt(this.formwindow.blockwidthTF.getText());
        }
        catch (NumberFormatException e) {
            System.err.println("Insert-Error");
            JOptionPane.showMessageDialog(null, "The inserted values are not correct! All edges are initialized with 0.  \r\nYou can change these values in the format-file.", "Incorrect insert", 2);
        }
        textblockwidth = width == 0 ? "%\\setlength{\\textwidth}{" + width + "mm}" + "\r\n" : "\\setlength{\\textwidth}{" + width + "mm}" + "\r\n";
        return textblockwidth;
    }

    public String getTextblockHeight() {
        String textblockheight = null;
        int height = 0;
        try {
            height = Integer.parseInt(this.formwindow.blockheightTF.getText());
        }
        catch (NumberFormatException e) {
            System.err.println("Insert-Error");
            JOptionPane.showMessageDialog(null, "The inserted values are not correct! All edges are initialized with 0.  mit 0 initialisiert.\r\nYou can change these values in the format-file.", "Incorrect insert", 2);
        }
        textblockheight = height == 0 ? "%\\setlength{\\textheight}{" + height + "mm}" + "\r\n" : "\\setlength{\\textheight}{" + height + "mm}" + "\r\n";
        return textblockheight;
    }
}

