/*
 * Decompiled with CFR 0.152.
 */
package de.beagtex.control;

import de.beagtex.gui.Editor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.undo.CannotUndoException;

public class UndoAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    Editor editor;

    public UndoAction(Editor pEdtior) {
        this.editor = pEdtior;
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        this.actionPerformedEditor();
    }

    public void update() {
        this.updateEditor();
    }

    private void actionPerformedEditor() {
        try {
            this.editor.getUndoMan().undo();
        }
        catch (CannotUndoException ex) {
            System.err.println("Kein weiterer Undo m\u00f6glich!");
        }
        this.update();
        this.editor.redoAction.update();
    }

    private void updateEditor() {
        if (this.editor.getUndoMan().canUndo()) {
            this.setEnabled(true);
            this.putValue("Name", this.editor.getUndoMan().getUndoPresentationName());
            this.editor.getBFrame().getBlButtons().getSaveB().setEnabled(true);
        } else {
            this.setEnabled(false);
            this.putValue("Name", "Undo");
        }
    }
}

