/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class ScientificFormat
extends Format {
    private int sigDigits = 5;
    private int maxWidth = 8;
    private boolean useSciNotation = false;
    private static final double ONE_OVER__LOG10 = 1.0 / Math.log(10.0);

    public ScientificFormat() {
    }

    public ScientificFormat(int sigDigits, int maxWidth, boolean useSciNotation) {
        this.setSigDigits(sigDigits);
        this.setMaxWidth(maxWidth);
        this.setNotationStyle(useSciNotation);
    }

    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    public int getSigDigits() {
        return this.sigDigits;
    }

    public void setSigDigits(int sigDigits) {
        if (sigDigits < 1) {
            sigDigits = 1;
        }
        this.sigDigits = sigDigits;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        if (maxWidth < 3) {
            maxWidth = 3;
        }
        this.maxWidth = maxWidth;
    }

    public boolean getNotationStyle() {
        return this.useSciNotation;
    }

    public void setNotationStyle(boolean useSciNotation) {
        this.useSciNotation = useSciNotation;
    }

    private static double log10(double x) {
        if (x == 0.0) {
            return 0.0;
        }
        return Math.log(x) * ONE_OVER__LOG10;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Number) {
            return toAppendTo.append(this.format(((Number)obj).doubleValue()));
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public String format(double d) {
        if (Double.isInfinite(d)) {
            return this.maxWidth < 8 ? "INF" : "Infinite";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        StringBuffer result = new StringBuffer();
        double c = 0.0;
        int shiftNumber = 0;
        int intOfLog10 = 0;
        if (d == 0.0) {
            return "0.";
        }
        c = d;
        intOfLog10 = (int)Math.floor(ScientificFormat.log10(d = Math.abs(c)));
        if (intOfLog10 > -1 && d % Math.pow(10.0, intOfLog10 + 1) == 0.0) {
            ++intOfLog10;
        }
        shiftNumber = ScientificFormat.log10(d) < 0.0 ? this.sigDigits - intOfLog10 - 1 : this.sigDigits - intOfLog10 - 1;
        StringBuffer formatted = new StringBuffer(String.valueOf(Math.round(Math.pow(10.0, shiftNumber) * d)));
        long bunk = new BigDecimal(Math.pow(10.0, shiftNumber) * d).longValue();
        String formattedbunk = String.valueOf(bunk);
        if (formatted.length() > formattedbunk.length()) {
            ++intOfLog10;
        }
        if (this.useSciNotation) {
            formatted.insert(1, ".");
            formatted.append("E" + intOfLog10);
            if (c < 0.0) {
                formatted.insert(0, "-");
            }
            return formatted.toString();
        }
        if (intOfLog10 < 0) {
            result.append("0.");
            int a = 0;
            while (a < Math.abs(intOfLog10) - 1) {
                result.append("0");
                ++a;
            }
            result.append(formatted.toString());
        } else {
            String[] fillDigits = new String[intOfLog10 + 1];
            int a = 0;
            while (a <= intOfLog10) {
                fillDigits[a] = "0";
                ++a;
            }
            int a2 = 0;
            while (a2 < formatted.length() && a2 <= intOfLog10) {
                fillDigits[a2] = formatted.substring(a2, a2 + 1);
                ++a2;
            }
            int i = 0;
            while (i <= fillDigits.length - 1) {
                result.append(fillDigits[i]);
                ++i;
            }
            int length = result.length();
            if (length < this.sigDigits) {
                StringBuffer resultaddon = new StringBuffer();
                int i2 = -1;
                if (intOfLog10 == 0) {
                    while (length < this.sigDigits) {
                        resultaddon.append(formatted.substring(result.length() + i2 + 1, result.length() + i2 + 2));
                        ++length;
                        ++i2;
                    }
                } else {
                    i2 = 0;
                    while (length < this.sigDigits) {
                        resultaddon.append(formatted.substring(result.length() + i2, result.length() + i2 + 1));
                        ++length;
                        ++i2;
                    }
                }
                result.append("." + resultaddon.toString());
            }
        }
        if (result.length() > this.maxWidth) {
            result.replace(0, result.length(), formatted.substring(0, 1) + "." + formatted.substring(1, this.sigDigits) + "E" + intOfLog10);
        }
        if (c < 0.0) {
            result.insert(0, "-");
        }
        return result.toString();
    }
}

