/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NCDataset;
import java.text.NumberFormat;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dataset.VariableDS;

public class NCPlotAxis {
    public static final int OTHER = -1;
    public static final int LONGITUDE = 1;
    public static final int LATITUDE = 2;
    public static final int VERTICAL = 3;
    private NCDataset dataset;
    private Variable variable;
    private String name;
    private int type = -1;
    private int numVals;
    private double[] values;
    private double[][] bounds;
    private boolean flipped = false;
    private NumberFormat nFormat = NumberFormat.getNumberInstance();

    public NCPlotAxis(NCDataset dataset, String name) {
        this(dataset, (Variable)dataset.findVariable(name));
    }

    public NCPlotAxis(NCDataset dataset, Variable variable) {
        this.dataset = dataset;
        this.variable = variable;
        String name = variable.getName();
        this.type = NCPlotAxis.getAxisType(name);
        try {
            double val0;
            this.numVals = variable.getShape()[0];
            this.values = new double[this.numVals];
            this.bounds = new double[this.numVals][2];
            Array array = variable.read();
            double val1 = val0 = array.getDouble(array.getIndex().set(0));
            if (this.numVals >= 2) {
                Attribute direction;
                val1 = array.getDouble(array.getIndex().set(1));
                if (this.type == 2 && val0 < val1) {
                    array = array.flip(0);
                    this.flipped = true;
                } else if (this.type == 1 && val0 > val1) {
                    array = array.flip(0);
                    this.flipped = true;
                } else if (this.type == 3 && (direction = variable.findAttribute("positive")) != null && direction.getStringValue().equals("up")) {
                    array = array.flip(0);
                    this.flipped = true;
                }
            }
            int j = 0;
            while (j < this.numVals) {
                this.values[j] = array.getDouble(array.getIndex().set(j));
                ++j;
            }
            VariableDS bVar = null;
            try {
                Attribute bAttr = variable.findAttributeIgnoreCase("bounds");
                bVar = dataset.findVariable(bAttr.getStringValue());
            }
            catch (Exception exc) {
                // empty catch block
            }
            if (bVar == null) {
                if (this.type == 2) {
                    this.bounds[0][0] = 90.0;
                    this.bounds[this.numVals - 1][1] = -90.0;
                } else if (this.type == 1) {
                    this.bounds[0][0] = 0.5 * (this.values[this.numVals - 1] - 360.0 + this.values[0]);
                    this.bounds[this.numVals - 1][1] = this.bounds[0][0] + 360.0;
                } else {
                    this.bounds[0][0] = this.values[0];
                    this.bounds[this.numVals - 1][1] = this.values[this.numVals - 1];
                }
                if (this.numVals > 1) {
                    int i = 0;
                    while (i < this.numVals - 1) {
                        this.bounds[i][1] = 0.5 * (this.values[i] + this.values[i + 1]);
                        ++i;
                    }
                    int i2 = 1;
                    while (i2 < this.numVals) {
                        this.bounds[i2][0] = this.bounds[i2 - 1][1];
                        ++i2;
                    }
                }
                return;
            }
            Array bArray = bVar.read();
            if (this.numVals > 1) {
                double b10;
                if (this.flipped) {
                    bArray = bArray.flip(0);
                }
                if ((b10 = bArray.getDouble(bArray.getIndex().set(1, 0))) < val0 && b10 < val1 || b10 > val0 && b10 > val1) {
                    bArray = bArray.flip(1);
                }
            }
            int i = 0;
            while (i < this.numVals) {
                this.bounds[i][0] = bArray.getDouble(bArray.getIndex().set(i, 0));
                this.bounds[i][1] = bArray.getDouble(bArray.getIndex().set(i, 1));
                ++i;
            }
        }
        catch (Exception exc) {
            System.out.println("NCPlotAxis : " + name);
            System.out.println("NCPlotAxis : " + exc.toString());
            exc.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.values.length;
    }

    public int getType() {
        return this.type;
    }

    public double[] getValues() {
        return this.values;
    }

    public double[][] getBounds() {
        return this.bounds;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public String getLongName() {
        StringBuffer sb = new StringBuffer();
        if (this.variable.findAttribute("long_name") != null) {
            sb.append(this.variable.findAttribute("long_name").getStringValue());
        } else if (this.variable.findAttribute("standard_name") != null) {
            sb.append(this.variable.findAttribute("standard_name").getStringValue().replace('_', ' '));
        } else {
            return "-";
        }
        if (sb.charAt(sb.length() - 1) != ' ') {
            return sb.toString();
        }
        int isize = sb.length();
        int i = 0;
        while (i < isize) {
            if (sb.charAt(sb.length() - 1) != ' ') {
                return sb.toString();
            }
            sb.deleteCharAt(sb.length() - 1);
            ++i;
        }
        if (sb.length() == 0) {
            return "-";
        }
        return sb.toString();
    }

    public String getUnits() {
        StringBuffer sb = new StringBuffer();
        if (this.variable.findAttribute("units") == null) {
            return "";
        }
        sb.append(this.variable.findAttribute("units").getStringValue());
        if (sb.charAt(sb.length() - 1) != ' ') {
            return sb.toString();
        }
        int isize = sb.length();
        int i = 0;
        while (i < isize) {
            if (sb.charAt(sb.length() - 1) != ' ') {
                return sb.toString();
            }
            sb.deleteCharAt(sb.length() - 1);
            ++i;
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.toString();
    }

    public String valueAt(int index, int digits) {
        this.nFormat.setMinimumFractionDigits(digits);
        this.nFormat.setMaximumFractionDigits(digits);
        return this.nFormat.format(this.valueAt(index));
    }

    public double valueAt(int index) {
        return this.values[index];
    }

    public int findNearestIndex(double value) {
        if (this.type == 2 && (value < -90.0 || value > 90.0)) {
            return -1;
        }
        if (this.type == 1 && value < this.bounds[0][0]) {
            value += 360.0;
        }
        int i = 0;
        while (i < this.numVals) {
            if (!(value < this.bounds[i][0] && value < this.bounds[i][1] || value > this.bounds[i][0] && value > this.bounds[i][1])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getAxisType(String aname) {
        if (aname == null) {
            return -1;
        }
        String lcname = aname.toLowerCase();
        if (lcname.equals("lon") || lcname.equals("longitude")) {
            return 1;
        }
        if (lcname.equals("lat") || lcname.equals("latitude")) {
            return 2;
        }
        if (lcname.equals("alt") || lcname.equals("altitude") || lcname.equals("vert") || lcname.equals("vertical") || lcname.equals("lev") || lcname.equals("level") || lcname.equals("hgt") || lcname.equals("height") || lcname.equals("z") || lcname.equals("p") || lcname.equals("depth")) {
            return 3;
        }
        return -1;
    }
}

