/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.math;

import java.text.NumberFormat;

public final class MathStrings {
    public static String zeroPadInt(long input, int oLength) {
        StringBuffer result = new StringBuffer(Integer.toString((int)input));
        if (oLength > 0) {
            while (result.length() < oLength) {
                result.insert(0, "0");
            }
        }
        return result.toString();
    }

    public static String zeroPadInt(int input, int oLength) {
        StringBuffer result = new StringBuffer(Integer.toString(input));
        if (oLength > 0) {
            while (result.length() < oLength) {
                result.insert(0, "0");
            }
        }
        return result.toString();
    }

    public static String padInt(long input, int oLength, char padChar) {
        StringBuffer result = new StringBuffer(Integer.toString((int)input));
        if (oLength > 0) {
            while (result.length() < oLength) {
                result.insert(0, padChar);
            }
        }
        return result.toString();
    }

    public static String formatDouble(double input, int precision) {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        formatter.setMinimumFractionDigits(precision);
        formatter.setMaximumFractionDigits(precision);
        formatter.setGroupingUsed(false);
        return formatter.format(input);
    }

    public static String formatDouble(double input, int oLength, int precision) {
        return MathStrings.formatDouble(input, oLength, precision, ' ');
    }

    public static String formatDouble(double input, int oLength, int precision, char padChar) {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        formatter.setMinimumFractionDigits(precision);
        formatter.setMaximumFractionDigits(precision);
        formatter.setGroupingUsed(false);
        StringBuffer result = new StringBuffer(formatter.format(input));
        if (oLength > 0) {
            while (result.length() < oLength) {
                result.insert(0, padChar);
            }
        }
        return result.toString();
    }
}

