/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24.applet;

import com.skatecity.gui.FGConstraint;
import com.skatecity.gui.FlexingGridLayout;
import gov.nasa.giss.mapping.proj.Projection;
import gov.nasa.giss.mars24.Landmark;
import gov.nasa.giss.mars24.LandmarkList;
import gov.nasa.giss.mars24.applet.M24Canvas;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;

public class M24ControlPanel
extends Panel
implements ActionListener,
ItemListener,
MouseListener,
FocusListener {
    private static final double DEFAULT_COP_LONGITUDE = 0.0;
    private static final double DEFAULT_COP_LATITUDE = 45.0;
    private static final String ORTHOGRAPHIC_STRING = "Orthographic";
    private static final String EQUIRECT_STRING = "Equirectangular";
    private static final String MOLLWEIDE_STRING = "Mollweide";
    private static final String WINKEL_TRIPEL_STRING = "Winkel Tripel";
    private static final String HORIZON_STRING = "Local Horizon";
    private static final String ORBIT_STRING = "Orbital Position";
    private M24Canvas canvas;
    private LandmarkList landmarks;
    private Choice displayMenu;
    private Panel timeSitePanel;
    private Label timeSiteLabel;
    private Choice timeSiteChoice;
    private TextField timeSiteLonTF;
    private Label timeSiteLonLabel;
    private TextField timeSiteLatTF;
    private Label timeSiteLatLabel;
    private Button timeSiteButton;
    private Label copLocLabel;
    private Panel copLocPanel;
    private Choice copChoice;
    private TextField copLonTF;
    private Label copLonLabel;
    private TextField copLatTF;
    private Label copLatLabel;
    private Button copButton;
    private double copLon;
    private double copLat;
    private Label horizonLabel;
    private Choice horizonChoice;
    private Label markLabel;
    private Panel markPanel;
    private Checkbox markSubsolarCB;
    private Checkbox markLandersCB;
    private Checkbox markLLGridCB;
    private Choice timeFormChoice;
    private Choice timeMethodChoice;
    private Label utcLabel;
    private Panel utcPanel;
    private TextField fixedDateTF;
    private TextField fixedTimeTF;
    private Button fixedTimeButton;
    private static NumberFormat nFormat = NumberFormat.getNumberInstance();
    private static Font helvetica10 = new Font("Helvetica", 0, 10);
    private static Font helvetica10b = new Font("Helvetica", 1, 10);

    public M24ControlPanel(M24Canvas canvas, LandmarkList landmarks) {
        this(canvas, landmarks, 0.0, 45.0);
    }

    public M24ControlPanel(M24Canvas canvas, LandmarkList landmarks, double copLon, double copLat) {
        this.canvas = canvas;
        this.landmarks = landmarks;
        this.copLon = copLon;
        this.copLat = copLat;
        this.setBackground(Color.white);
        canvas.setCOPLonLat(copLon, copLat);
        Label displayLabel = new Label(" Display: ", 2);
        displayLabel.setFont(helvetica10);
        this.displayMenu = new Choice();
        this.displayMenu.add(ORTHOGRAPHIC_STRING);
        this.displayMenu.add(EQUIRECT_STRING);
        this.displayMenu.add(MOLLWEIDE_STRING);
        this.displayMenu.add(WINKEL_TRIPEL_STRING);
        this.displayMenu.add(ORBIT_STRING);
        this.displayMenu.add(HORIZON_STRING);
        this.displayMenu.setFont(helvetica10);
        this.timeSiteLabel = new Label(" Time at: ", 2);
        this.timeSiteLabel.setFont(helvetica10);
        this.timeSitePanel = this.makeTimeSitePanel();
        this.copLocLabel = new Label(" Center on: ", 2);
        this.copLocLabel.setFont(helvetica10);
        this.copLocPanel = this.makeCOPPanel();
        this.markLabel = new Label(" Mark: ", 2);
        this.markLabel.setFont(helvetica10);
        this.markPanel = this.makeMapOptionsPanel();
        this.horizonLabel = new Label(" Centered: ", 2);
        this.horizonLabel.setFont(helvetica10);
        this.horizonChoice = new Choice();
        this.horizonChoice.add("Looking South");
        this.horizonChoice.add("Looking North");
        this.horizonChoice.setFont(helvetica10);
        Label usingLabel = new Label("Show: ", 2);
        Label timeLabel = new Label("Time is: ", 2);
        usingLabel.setFont(helvetica10);
        timeLabel.setFont(helvetica10);
        this.timeFormChoice = new Choice();
        this.timeFormChoice.add("Local Mean Solar Time (LMST)");
        this.timeFormChoice.add("Local True Solar Time (LTST)");
        this.timeFormChoice.add("Local Mean Zonal Time (LTZT)");
        this.timeFormChoice.setFont(helvetica10);
        this.timeMethodChoice = new Choice();
        this.timeMethodChoice.add("Current Date & Time");
        this.timeMethodChoice.add("Fixed Date & Time (UTC)");
        this.timeMethodChoice.setFont(helvetica10);
        this.utcLabel = new Label("UTC is: ", 2);
        this.utcLabel.setFont(helvetica10);
        this.utcPanel = this.makeUTCPanel();
        canvas.addMouseListener(this);
        this.displayMenu.addItemListener(this);
        this.horizonChoice.addItemListener(this);
        this.timeMethodChoice.addItemListener(this);
        this.timeFormChoice.addItemListener(this);
        this.fixedTimeButton.addActionListener(this);
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(5, 4), 2, 0);
        fgl.setColumnWeight(0, 0.0f);
        fgl.setColumnWeight(1, 0.0f);
        fgl.setColumnWeight(2, 1.0f);
        fgl.setColumnWeight(3, 0.0f);
        fgl.setColumnWeight(4, 0.0f);
        this.setLayout(fgl);
        this.add((Component)displayLabel, new FGConstraint(new Rectangle(0, 0, 1, 1), 1.0, 0.5));
        this.add((Component)this.displayMenu, new FGConstraint(new Rectangle(1, 0, 1, 1), 0.0, 0.5));
        this.add((Component)this.timeSiteLabel, new FGConstraint(new Rectangle(0, 1, 1, 1), 1.0, 0.5));
        this.add((Component)this.timeSitePanel, new FGConstraint(new Rectangle(1, 1, 1, 1), 0.0, 0.5));
        this.add((Component)this.copLocLabel, new FGConstraint(new Rectangle(0, 2, 1, 1), 1.0, 0.5));
        this.add((Component)this.copLocPanel, new FGConstraint(new Rectangle(1, 2, 1, 1), 0.0, 0.5));
        this.add((Component)this.markLabel, new FGConstraint(new Rectangle(0, 3, 1, 1), 1.0, 0.5));
        this.add((Component)this.markPanel, new FGConstraint(new Rectangle(1, 3, 1, 1), 0.0, 0.5));
        this.add((Component)this.horizonLabel, new FGConstraint(new Rectangle(0, 2, 1, 1), 1.0, 0.5));
        this.add((Component)this.horizonChoice, new FGConstraint(new Rectangle(1, 2, 1, 1), 0.0, 0.5));
        this.add((Component)usingLabel, new FGConstraint(new Rectangle(3, 0, 1, 1), 1.0, 0.5));
        this.add((Component)this.timeFormChoice, new FGConstraint(new Rectangle(4, 0, 1, 1), 0.0, 0.5));
        this.add((Component)timeLabel, new FGConstraint(new Rectangle(3, 1, 1, 1), 1.0, 0.5));
        this.add((Component)this.timeMethodChoice, new FGConstraint(new Rectangle(4, 1, 1, 1), 0.0, 0.5));
        this.add((Component)this.utcLabel, new FGConstraint(new Rectangle(3, 2, 1, 1), 1.0, 0.5));
        this.add((Component)this.utcPanel, new FGConstraint(new Rectangle(4, 2, 1, 1), 0.0, 0.5));
        this.displayMenu.select(ORTHOGRAPHIC_STRING);
        this.handleDisplayControls();
        canvas.setDisplayChoice(Projection.getProjectionID(this.displayMenu.getSelectedItem()));
        canvas.setTimeMethod(1);
        this.showTimeControls(false);
        canvas.setShowSubsolar(this.markSubsolarCB.getState());
        canvas.setShowLanders(this.markLandersCB.getState());
        canvas.setShowLLGrid(this.markLLGridCB.getState());
        canvas.setHorizonCenter(2);
        canvas.setTimeForm(2);
        canvas.setTimeSiteLonLat(this.timeSiteLonTF.getText(), this.timeSiteLatTF.getText());
        canvas.setCOPLonLat(copLon, copLat);
    }

    private Panel makeTimeSitePanel() {
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        this.timeSiteChoice = new Choice();
        this.timeSiteChoice.add("-->");
        int lsize = this.landmarks.count();
        int i = 0;
        while (i < lsize) {
            Landmark landmark = this.landmarks.getElement(i);
            if (landmark.getType() == 2) {
                this.timeSiteChoice.add("L: " + landmark.getName());
            } else if (landmark.getType() == 1) {
                this.timeSiteChoice.add("P: " + landmark.getName());
            } else if (landmark.getType() == 3) {
                this.timeSiteChoice.add("C: " + landmark.getName());
            } else if (landmark.getType() == 4) {
                this.timeSiteChoice.add("F: " + landmark.getName());
            }
            ++i;
        }
        this.timeSiteLonTF = new TextField("0.0", 5);
        this.timeSiteLonLabel = new Label("\u00b0W ", 0);
        this.timeSiteLatTF = new TextField("0.0", 5);
        this.timeSiteLatLabel = new Label("\u00b0N ", 0);
        this.timeSiteButton = new Button("Set!");
        this.timeSiteChoice.setFont(helvetica10);
        this.timeSiteLonTF.setFont(helvetica10);
        this.timeSiteLonLabel.setFont(helvetica10);
        this.timeSiteLatTF.setFont(helvetica10);
        this.timeSiteLatLabel.setFont(helvetica10);
        this.timeSiteButton.setFont(helvetica10);
        this.timeSiteLonTF.setBackground(Color.white);
        this.timeSiteLatTF.setBackground(Color.white);
        this.timeSiteChoice.addItemListener(this);
        this.timeSiteButton.addActionListener(this);
        this.timeSiteLonTF.addActionListener(this);
        this.timeSiteLonTF.addFocusListener(this);
        this.timeSiteLatTF.addActionListener(this);
        this.timeSiteLatTF.addFocusListener(this);
        panel.add(this.timeSiteChoice);
        panel.add(this.timeSiteLonTF);
        panel.add(this.timeSiteLonLabel);
        panel.add(this.timeSiteLatTF);
        panel.add(this.timeSiteLatLabel);
        panel.add(this.timeSiteButton);
        return panel;
    }

    private Panel makeCOPPanel() {
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        this.copChoice = new Choice();
        this.copChoice.add("-->");
        int lsize = this.landmarks.count();
        int i = 0;
        while (i < lsize) {
            Landmark landmark = this.landmarks.getElement(i);
            if (landmark.getType() == 2) {
                this.copChoice.add("L: " + landmark.getName());
            } else if (landmark.getType() == 1) {
                this.copChoice.add("P: " + landmark.getName());
            } else if (landmark.getType() == 3) {
                this.copChoice.add("C: " + landmark.getName());
            } else if (landmark.getType() == 4) {
                this.copChoice.add("F: " + landmark.getName());
            }
            ++i;
        }
        this.copLonTF = new TextField("0.0", 5);
        this.copLonLabel = new Label("\u00b0W ", 0);
        this.copLatTF = new TextField("0.0", 5);
        this.copLatLabel = new Label("\u00b0N ", 0);
        this.copButton = new Button("Set!");
        this.copChoice.setFont(helvetica10);
        this.copLonTF.setFont(helvetica10);
        this.copLonLabel.setFont(helvetica10);
        this.copLatTF.setFont(helvetica10);
        this.copLatLabel.setFont(helvetica10);
        this.copButton.setFont(helvetica10);
        this.copLonTF.setBackground(Color.white);
        this.copLatTF.setBackground(Color.white);
        this.copChoice.addItemListener(this);
        this.copButton.addActionListener(this);
        this.copLonTF.addActionListener(this);
        this.copLonTF.addFocusListener(this);
        this.copLatTF.addActionListener(this);
        this.copLatTF.addFocusListener(this);
        panel.add(this.copChoice);
        panel.add(this.copLonTF);
        panel.add(this.copLonLabel);
        panel.add(this.copLatTF);
        panel.add(this.copLatLabel);
        panel.add(this.copButton);
        return panel;
    }

    private Panel makeMapOptionsPanel() {
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        this.markSubsolarCB = new Checkbox("Sun/time points ", false);
        this.markLandersCB = new Checkbox("Landers ", false);
        this.markLLGridCB = new Checkbox("Lat-lon grid ", false);
        this.markSubsolarCB.setFont(helvetica10);
        this.markLandersCB.setFont(helvetica10);
        this.markLLGridCB.setFont(helvetica10);
        this.markSubsolarCB.addItemListener(this);
        this.markLandersCB.addItemListener(this);
        this.markLLGridCB.addItemListener(this);
        panel.add(this.markSubsolarCB);
        panel.add(new Label(" "));
        panel.add(this.markLandersCB);
        panel.add(new Label(" "));
        panel.add(this.markLLGridCB);
        panel.add(new Panel());
        return panel;
    }

    private Panel makeUTCPanel() {
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        this.fixedDateTF = new TextField("July 20, 1976", 12);
        Label onLabel = new Label(" on ");
        this.fixedTimeTF = new TextField("11:53:00", 8);
        this.fixedTimeButton = new Button("Set!");
        this.fixedDateTF.setFont(helvetica10);
        onLabel.setFont(helvetica10);
        this.fixedTimeTF.setFont(helvetica10);
        this.fixedTimeButton.setFont(helvetica10);
        this.fixedDateTF.setBackground(Color.white);
        this.fixedTimeTF.setBackground(Color.white);
        this.fixedDateTF.addActionListener(this);
        this.fixedDateTF.addFocusListener(this);
        this.fixedTimeTF.addActionListener(this);
        this.fixedTimeTF.addFocusListener(this);
        panel.add(this.fixedTimeTF);
        panel.add(onLabel);
        panel.add(this.fixedDateTF);
        panel.add(this.fixedTimeButton);
        panel.add(new Label(" "));
        return panel;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.canvas.redraw();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.timeSiteButton) || e.getSource().equals(this.timeSiteLonTF) || e.getSource().equals(this.timeSiteLatTF)) {
            this.handleTimeSiteTextFields();
        } else if (e.getSource().equals(this.copButton) || e.getSource().equals(this.copLonTF) || e.getSource().equals(this.copLatTF)) {
            this.handleCOPTextFields();
        } else if (e.getSource().equals(this.fixedTimeButton) || e.getSource().equals(this.fixedDateTF) || e.getSource().equals(this.fixedTimeTF)) {
            this.handleFixedTimeTextFields();
        }
    }

    public void focusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        if (e.getSource().equals(this.timeSiteLonTF) || e.getSource().equals(this.timeSiteLatTF)) {
            this.handleTimeSiteTextFields();
        } else if (e.getSource().equals(this.copLonTF) || e.getSource().equals(this.copLatTF)) {
            this.handleCOPTextFields();
        } else if (e.getSource().equals(this.fixedDateTF) || e.getSource().equals(this.fixedTimeTF)) {
            this.handleFixedTimeTextFields();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        Object theObject = e.getSource();
        String newValue = (String)e.getItem();
        if (theObject.equals(this.displayMenu)) {
            int displayChoice = 0;
            displayChoice = this.displayMenu.getSelectedItem().equals(HORIZON_STRING) ? -1 : (this.displayMenu.getSelectedItem().equals(ORBIT_STRING) ? -2 : Projection.getProjectionID(this.displayMenu.getSelectedItem()));
            if (displayChoice != 0) {
                this.handleDisplayControls();
                this.canvas.setDisplayChoice(displayChoice);
            }
        } else if (theObject.equals(this.timeSiteChoice)) {
            int i = 0;
            while (i < this.landmarks.count()) {
                Landmark landmark = this.landmarks.getElement(i);
                if (newValue.indexOf(landmark.getName()) > -1) {
                    this.canvas.setTimeSiteLonLat(landmark.getLongitude(), landmark.getLatitude());
                    this.setTimeSiteTextFields(false);
                    break;
                }
                ++i;
            }
        } else if (theObject.equals(this.copChoice)) {
            int i = 0;
            while (i < this.landmarks.count()) {
                Landmark landmark = this.landmarks.getElement(i);
                if (newValue.indexOf(landmark.getName()) > -1) {
                    this.canvas.setCOPLonLat(landmark.getLongitude(), landmark.getLatitude());
                    this.setCOPTextFields(false);
                    break;
                }
                ++i;
            }
        } else if (theObject.equals(this.timeFormChoice)) {
            if (newValue.indexOf("Mean Solar") > 0) {
                this.canvas.setTimeForm(2);
            } else if (newValue.indexOf("True Solar") > 0) {
                this.canvas.setTimeForm(1);
            } else if (newValue.indexOf("Zonal Time") > 0) {
                this.canvas.setTimeForm(3);
            } else if (newValue.indexOf("Coordinated") > 0) {
                this.canvas.setTimeForm(4);
            }
        } else if (theObject.equals(this.timeMethodChoice)) {
            if (newValue.startsWith("Current")) {
                this.canvas.setTimeMethod(1);
                this.showTimeControls(false);
            } else {
                this.canvas.setTimeMethod(2, this.fixedDateTF.getText() + " " + this.fixedTimeTF.getText());
                this.showTimeControls(true);
            }
            this.utcPanel.invalidate();
        } else if (theObject.equals(this.horizonChoice)) {
            if (newValue.indexOf("North") > 0) {
                this.canvas.setHorizonCenter(1);
            } else {
                this.canvas.setHorizonCenter(2);
            }
        } else if (theObject.equals(this.markLLGridCB)) {
            this.canvas.setShowLLGrid(e.getStateChange() == 1);
        } else if (theObject.equals(this.markLandersCB)) {
            this.canvas.setShowLanders(e.getStateChange() == 1);
        } else if (theObject.equals(this.markSubsolarCB)) {
            this.canvas.setShowSubsolar(e.getStateChange() == 1);
        }
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (!this.displayMenu.getSelectedItem().equals(HORIZON_STRING) && !this.displayMenu.getSelectedItem().equals(ORBIT_STRING) && x < 720 && y < 444) {
            if (e.isShiftDown()) {
                this.canvas.setCOPByPoint(x, y);
                this.copChoice.select(0);
                this.setCOPTextFields(true);
            } else {
                this.canvas.setTimeSiteByPoint(x, y);
                this.timeSiteChoice.select(0);
                this.setTimeSiteTextFields(true);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void handleTimeSiteTextFields() {
        this.timeSiteChoice.select(0);
        this.canvas.setTimeSiteLonLat(this.timeSiteLonTF.getText(), this.timeSiteLatTF.getText());
        this.setTimeSiteTextFields(false);
    }

    private void setTimeSiteTextFields(boolean roundOff) {
        if (roundOff) {
            this.timeSiteLonTF.setText(nFormat.format(this.canvas.getTimeSiteLongitude()));
            this.timeSiteLatTF.setText(nFormat.format(this.canvas.getTimeSiteLatitude()));
        } else {
            this.timeSiteLonTF.setText(this.canvas.getTimeSiteLongitude() + "");
            this.timeSiteLatTF.setText(this.canvas.getTimeSiteLatitude() + "");
        }
    }

    private void handleCOPTextFields() {
        this.copChoice.select(0);
        this.canvas.setCOPLonLat(this.copLonTF.getText(), this.copLatTF.getText());
        this.setCOPTextFields(false);
    }

    private void setCOPTextFields(boolean roundOff) {
        if (roundOff) {
            this.copLonTF.setText(nFormat.format(this.canvas.getCOPLongitude()));
            this.copLatTF.setText(nFormat.format(this.canvas.getCOPLatitude()));
        } else {
            this.copLonTF.setText(this.canvas.getCOPLongitude() + "");
            this.copLatTF.setText(this.canvas.getCOPLatitude() + "");
        }
    }

    private void handleFixedTimeTextFields() {
        if (this.timeMethodChoice.getSelectedItem().startsWith("Fixed")) {
            this.canvas.setTimeMethod(2, this.fixedDateTF.getText() + " " + this.fixedTimeTF.getText());
        }
    }

    private void handleDisplayControls() {
        String choice = this.displayMenu.getSelectedItem();
        if (choice.equals(HORIZON_STRING) || choice.equals(ORBIT_STRING)) {
            this.copLocPanel.setVisible(false);
            this.copLocLabel.setVisible(false);
            this.copChoice.setVisible(false);
            this.copChoice.setEnabled(false);
            this.copLonTF.setVisible(false);
            this.copLonTF.setEnabled(false);
            this.copLatTF.setVisible(false);
            this.copLatTF.setEnabled(false);
            this.copButton.setVisible(false);
            this.copButton.setEnabled(false);
            this.copLonLabel.setVisible(false);
            this.copLatLabel.setVisible(false);
            this.markLabel.setVisible(false);
            this.markPanel.setVisible(false);
            this.markSubsolarCB.setVisible(false);
            this.markSubsolarCB.setEnabled(false);
            this.markLandersCB.setVisible(false);
            this.markLandersCB.setEnabled(false);
            this.markLLGridCB.setVisible(false);
            this.markLLGridCB.setEnabled(false);
            this.horizonLabel.setVisible(choice.equals(HORIZON_STRING));
            this.horizonChoice.setVisible(choice.equals(HORIZON_STRING));
            this.horizonChoice.setEnabled(choice.equals(HORIZON_STRING));
        } else {
            this.copLocPanel.setVisible(true);
            this.copLocLabel.setVisible(true);
            this.copChoice.setVisible(true);
            this.copChoice.setEnabled(true);
            this.copLonTF.setVisible(true);
            this.copLonTF.setEnabled(true);
            this.copLonLabel.setVisible(true);
            this.copLatTF.setVisible(true);
            this.copLatTF.setEnabled(choice.equals(ORTHOGRAPHIC_STRING));
            this.copLatLabel.setVisible(true);
            this.copButton.setVisible(true);
            this.copButton.setEnabled(true);
            this.markLabel.setVisible(true);
            this.markPanel.setVisible(true);
            this.markSubsolarCB.setVisible(true);
            this.markSubsolarCB.setEnabled(true);
            this.markLandersCB.setVisible(true);
            this.markLandersCB.setEnabled(true);
            this.markLLGridCB.setVisible(choice.equals(EQUIRECT_STRING));
            this.markLLGridCB.setEnabled(choice.equals(EQUIRECT_STRING));
            this.horizonLabel.setVisible(false);
            this.horizonChoice.setVisible(false);
            this.horizonChoice.setEnabled(false);
        }
        this.validate();
        this.repaint();
    }

    private void showTimeControls(boolean show) {
        this.fixedDateTF.setEnabled(show);
        this.fixedTimeTF.setEnabled(show);
        this.fixedTimeButton.setEnabled(show);
        this.validate();
        this.repaint();
    }

    static {
        nFormat.setMinimumFractionDigits(2);
        nFormat.setMaximumFractionDigits(2);
    }
}

