/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24.applet;

import gov.nasa.giss.mapping.PointDouble;
import gov.nasa.giss.mapping.proj.Projection;
import gov.nasa.giss.mars24.Landmark;
import gov.nasa.giss.mars24.LandmarkList;
import gov.nasa.giss.mars24.M24HorizonPlotter;
import gov.nasa.giss.mars24.M24OrbitPlotter;
import gov.nasa.giss.mars24.applet.M24DayNightMap;
import gov.nasa.giss.math.Mathlib;
import gov.nasa.giss.time.EarthTime;
import gov.nasa.giss.time.JulianDate;
import gov.nasa.giss.time.MarsTime;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;

public class M24Canvas
extends Canvas {
    public static final int TIME_IS_CURRENT = 1;
    public static final int TIME_IS_FIXED = 2;
    public static final int SHOW_TIME_LTST = 1;
    public static final int SHOW_TIME_LMST = 2;
    public static final int SHOW_TIME_LMZT = 3;
    public static final int SHOW_TIME_MTC = 4;
    public static final int DRAW_HORIZON = -1;
    public static final int DRAW_ORBIT = -2;
    public static final int LOOK_NORTH = 1;
    public static final int LOOK_SOUTH = 2;
    private static final short PIX_PER_DEG = 2;
    private static final short PIX_60 = 120;
    private static final short PIX_90 = 180;
    private static final short PIX_120 = 240;
    private static final short PIX_180 = 360;
    private static final short PIX_240 = 480;
    private static final short PIX_270 = 540;
    private static final short PIX_360 = 720;
    private static final short FHGT_TIME_LRG = 16;
    private static final short FHGT_TIME_MED = 13;
    private static final short FHGT_NOTES = 11;
    private static final short FHGT_LABELS = 11;
    private static final short FHGT_TINY = 10;
    private static final Font FONT_TIME_LRG = new Font("Courier", 1, 16);
    private static final Font FONT_TIME_MED = new Font("Courier", 1, 13);
    private static final Font FONT_NOTES = new Font("Courier", 0, 11);
    private static final Font FONT_LABELS = new Font("Courier", 1, 11);
    private static final Font FONT_TINY = new Font("Courier", 0, 10);
    public static final short MAP_WIDTH = 720;
    public static final short MAP_HEIGHT = 360;
    public static final short PANEL_WIDTH = 720;
    public static final short PANEL_HEIGHT = 444;
    private static final short SMALL_DIAM = 364;
    private static final short SMALL_OFFSETX = 316;
    private static final short SMALL_OFFSETY = 40;
    private static final int CROSS = 0;
    private static final int CIRCLE = 1;
    private static final long REMAP_INTERVAL_M = 20000L;
    private static final long REMAP_INTERVAL_H = 10000L;
    private static final long REMAP_INTERVAL_F = 30000000L;
    private static final short REMAP_NOW = 0;
    private static final double UNKNOWN = 1000.0;
    private int displayChoice;
    private int projectionChoice;
    private int timeMethod = 1;
    private int timeForm = 2;
    private boolean showSubsolar = true;
    private boolean showLanders = true;
    private boolean showLLGrid = false;
    private int horizonDirect = 2;
    private double timeSiteLon;
    private double timeSiteLat;
    private double timezoneLon;
    private double copLon;
    private double copLat;
    private double subsolarLon;
    private double subsolarLat;
    private boolean canvasInitialized = false;
    private Image offscreenMain;
    private Image offscreenHorizon;
    private Image offscreenOrbit;
    private Image dayImage;
    private M24DayNightMap shadowMap;
    private Projection theProjection;
    private Image bigProjectionImage;
    private Image smallProjectionImage;
    private M24HorizonPlotter horizonPlotter;
    private M24OrbitPlotter orbitPlotter;
    private short offsetX;
    private short offsetY;
    private double aspectRatio;
    private LandmarkList landmarks;
    private boolean horizonNeedsUpdate = true;
    private boolean orbitNeedsUpdate = true;
    private boolean projectionChanged = true;
    private boolean projectionNeedsRedraw = true;
    private long timeMillis;
    private long timeNow;
    private long nextRemapTime = 0L;
    private Date fixedTimeValue = new Date();
    private boolean badTime = false;
    private static String version = "5.1";
    private static NumberFormat nFormat1 = NumberFormat.getNumberInstance();
    private static NumberFormat nFormat2 = NumberFormat.getNumberInstance();
    private static NumberFormat nFormat3 = NumberFormat.getNumberInstance();
    private static final DecimalFormat FORMAT02 = new DecimalFormat("00");

    public M24Canvas() {
        this.setSize(720, 444);
        this.setBackground(Color.black);
    }

    public M24Canvas(LandmarkList ll, Image img) {
        this();
        this.dayImage = img;
        this.landmarks = ll;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void redraw() {
        this.repaint();
    }

    public void paint(Graphics g) {
        if (!this.canvasInitialized) {
            this.offscreenMain = this.createImage(720, 444);
            this.offscreenHorizon = this.createImage(720, 360);
            this.offscreenOrbit = this.createImage(720, 444);
            this.shadowMap = new M24DayNightMap(this.dayImage, 720, 55);
            this.canvasInitialized = true;
        }
        Graphics ogfx = this.offscreenMain.getGraphics();
        if (this.badTime) {
            ogfx.setColor(Color.red);
            ogfx.setFont(FONT_TIME_LRG);
            FontMetrics fm = ogfx.getFontMetrics();
            String message = "Time/date out of valid range or not formatted well. Please re-enter.";
            ogfx.drawString(message, (720 - fm.stringWidth(message)) / 2, 214);
            g.drawImage(this.offscreenMain, 0, 0, this);
            ogfx.dispose();
            return;
        }
        ogfx.setColor(Color.black);
        ogfx.fillRect(0, 0, 720, 444);
        this.timeNow = System.currentTimeMillis();
        this.timeMillis = this.timeMethod == 2 ? this.fixedTimeValue.getTime() : this.timeNow;
        JulianDate julianTime = new JulianDate(this.timeMillis);
        MarsTime marsTime = new MarsTime(this.timeMillis);
        EarthTime earthTime = new EarthTime(this.timeMillis);
        this.subsolarLon = marsTime.getSubsolarLongitude();
        this.subsolarLat = marsTime.getSolarDeclination();
        if (this.displayChoice == -2) {
            this.drawOrbit(ogfx, marsTime, earthTime);
        } else if (this.displayChoice == -1) {
            this.drawHorizon(ogfx, marsTime);
        } else {
            this.drawMap(ogfx);
        }
        this.drawTime(ogfx, julianTime, marsTime, earthTime);
        ogfx.setColor(Color.white);
        ogfx.setFont(FONT_NOTES);
        FontMetrics fm = ogfx.getFontMetrics();
        if (this.displayChoice == -1 || this.displayChoice > 0 && this.aspectRatio > 1.0) {
            ogfx.drawString("NASA GISS", 5, 358);
            ogfx.drawString(version, 715 - fm.stringWidth(version), 358);
        } else {
            ogfx.drawString("NASA GISS", 5, 439);
            ogfx.drawString(version, 715 - fm.stringWidth(version), 439);
        }
        fm = ogfx.getFontMetrics();
        String diagnostics = System.currentTimeMillis() - this.timeNow + "";
        ogfx.setColor(Color.gray);
        ogfx.setFont(FONT_TINY);
        fm = ogfx.getFontMetrics();
        ogfx.drawString(diagnostics, 715 - fm.stringWidth(diagnostics), 10);
        g.drawImage(this.offscreenMain, 0, 0, this);
        ogfx.dispose();
    }

    public Image getImage() {
        return this.offscreenMain;
    }

    public double getTimeSiteLongitude() {
        return this.timeSiteLon;
    }

    public double getTimeSiteLatitude() {
        return this.timeSiteLat;
    }

    public double getCOPLongitude() {
        return this.copLon;
    }

    public double getCOPLatitude() {
        return this.copLat;
    }

    public void setDisplayChoice(int displayChoice) {
        this.displayChoice = displayChoice;
        if (displayChoice > 0) {
            if (displayChoice != this.projectionChoice) {
                this.projectionChanged = true;
            }
            this.projectionChoice = displayChoice;
            this.aspectRatio = Projection.getAspectRatio(displayChoice);
            if (this.aspectRatio > 1.0) {
                this.offsetX = 0;
                this.offsetY = 0;
            } else {
                this.offsetX = (short)316;
                this.offsetY = (short)40;
            }
            this.projectionNeedsRedraw = true;
        }
        this.nextRemapTime = 0L;
    }

    public void setTimeSiteLonLat(double lon, double lat) {
        if (lon == this.timeSiteLon && lat == this.timeSiteLat) {
            return;
        }
        this.timeSiteLon = lon;
        this.timeSiteLat = lat;
        this.timezoneLon = 15.0 * (double)((int)((this.timeSiteLon + 7.5) / 15.0));
        this.horizonNeedsUpdate = true;
    }

    public void setTimeSiteLonLat(String xString, String yString) {
        try {
            double lon = Double.valueOf(xString);
            double lat = Double.valueOf(yString);
            while (lat > 90.0) {
                lat -= 180.0;
            }
            while (lat < -90.0) {
                lat += 180.0;
            }
            while (lon > 360.0) {
                lon -= 360.0;
            }
            while (lon < 0.0) {
                lon += 360.0;
            }
            this.setTimeSiteLonLat(lon, lat);
        }
        catch (Exception exc) {
            System.out.println("setTimeSiteLonLat error : " + exc.toString());
        }
    }

    public void setTimeSiteByPoint(int x, int y) {
        if (this.theProjection == null) {
            return;
        }
        if (x < this.offsetX || y < this.offsetY) {
            return;
        }
        PointDouble latlong = this.theProjection.transformXY2LL(x - this.offsetX, y - this.offsetY);
        if (latlong == null) {
            return;
        }
        this.setTimeSiteLonLat(latlong.x, latlong.y);
    }

    public void setCOPLonLat(double lon, double lat) {
        if (lon == this.copLon && lat == this.copLat) {
            return;
        }
        this.copLon = lon;
        this.copLat = lat;
        if (this.theProjection != null) {
            this.theProjection.setCenter(this.copLon, this.copLat);
        }
        this.projectionNeedsRedraw = true;
        this.nextRemapTime = 0L;
    }

    public void setCOPLonLat(String xString, String yString) {
        try {
            double lon = Double.valueOf(xString);
            double lat = Double.valueOf(yString);
            while (lat > 90.0) {
                lat -= 180.0;
            }
            while (lat < -90.0) {
                lat += 180.0;
            }
            while (lon > 360.0) {
                lon -= 360.0;
            }
            while (lon < 0.0) {
                lon += 360.0;
            }
            this.setCOPLonLat(lon, lat);
        }
        catch (Exception exc) {
            System.out.println("setCOPLonLat error -- " + exc.toString());
            return;
        }
    }

    public void setCOPByPoint(int x, int y) {
        if (this.theProjection == null) {
            return;
        }
        if (x < this.offsetX || y < this.offsetY) {
            return;
        }
        PointDouble latlong = this.theProjection.transformXY2LL(x - this.offsetX, y - this.offsetY);
        if (latlong == null) {
            return;
        }
        this.setCOPLonLat(latlong.x, latlong.y);
    }

    public void setTimeMethod(int method) {
        this.timeMethod = method;
        this.projectionNeedsRedraw = true;
        this.nextRemapTime = 0L;
    }

    public void setTimeMethod(int method, String aString) {
        this.timeMethod = method;
        if (method == 2) {
            try {
                this.fixedTimeValue = new Date(aString + " GMT");
            }
            catch (Exception exc) {
                this.badTime = true;
                System.out.println("setTimeMethod -- " + exc.toString());
            }
            int year = this.fixedTimeValue.getYear() + 1900;
            this.badTime = year < 1750 || year > 2250;
        }
        this.projectionNeedsRedraw = true;
        this.nextRemapTime = 0L;
    }

    public void setTimeForm(int form) {
        this.timeForm = form;
    }

    public void setShowLLGrid(boolean value) {
        this.showLLGrid = value;
        this.nextRemapTime = 0L;
        this.projectionNeedsRedraw = true;
    }

    public void setShowSubsolar(boolean value) {
        this.showSubsolar = value;
    }

    public void setShowLanders(boolean value) {
        this.showLanders = value;
    }

    public void setHorizonCenter(int horizonDirect) {
        this.horizonDirect = horizonDirect;
        this.nextRemapTime = 0L;
    }

    private void drawTime(Graphics g, JulianDate julianTime, MarsTime marsTime, EarthTime earthTime) {
        int col3y;
        int col3x;
        int col2y;
        int col2x;
        int col1y;
        int col1x;
        if (this.displayChoice == -2 || this.displayChoice > 0 && this.aspectRatio < 1.01) {
            col1x = 0;
            col1y = 0;
            col2x = 0;
            col2y = 90;
            col3x = 0;
            col3y = 180;
        } else {
            col1x = 0;
            col1y = 360;
            col2x = 240;
            col2y = 360;
            col3x = 480;
            col3y = 360;
        }
        String airyMeanTime = marsTime.getTimestr(0.0, 1, false);
        String airySolarTime = marsTime.getTimestr(0.0, 2, false);
        StringBuffer mTimestrBuffer = new StringBuffer("");
        switch (this.timeForm) {
            case 1: {
                String localSolarTime = marsTime.getTimestr(this.timeSiteLon, 2, true);
                mTimestrBuffer.append(localSolarTime);
                break;
            }
            case 3: {
                String zoneTime = marsTime.getTimestr(this.timezoneLon, 1, false);
                mTimestrBuffer.append(zoneTime + " LMZT");
                break;
            }
            case 4: {
                mTimestrBuffer.append(airyMeanTime + " MTC");
                break;
            }
            default: {
                String localMeanTime = marsTime.getTimestr(this.timeSiteLon, 1, true);
                mTimestrBuffer.append(localMeanTime);
            }
        }
        double zenithAngle = marsTime.getZenithAngle(this.timeSiteLon, this.timeSiteLat);
        double azimuthAngle = marsTime.getAzimuthAngle(this.timeSiteLon, this.timeSiteLat);
        if (azimuthAngle < 0.0) {
            azimuthAngle += 360.0;
        }
        String elevationString = "Solar Elev. " + nFormat1.format(90.0 - zenithAngle) + "\u00b0";
        String azimuthString = "Solar Azim. " + nFormat1.format(azimuthAngle) + "\u00b0";
        g.setColor(Color.green);
        g.setFont(FONT_TIME_LRG);
        g.drawString(earthTime.getTime() + " UTC", col1x + 5, col1y + 16 + 5);
        g.setColor(Color.red);
        g.setFont(FONT_TIME_MED);
        g.drawString(earthTime.getDate(false, false), col1x + 5, col1y + 36);
        g.drawString("MJD " + nFormat3.format(julianTime.getJDate(2)), col1x + 5, col1y + 54);
        g.drawString("Dist. " + this.getLightTime(marsTime, earthTime), col1x + 5, col1y + 72);
        g.setColor(Color.green);
        g.setFont(FONT_TIME_LRG);
        g.drawString(airyMeanTime + " MTC", col2x + 5, col2y + 21);
        g.setColor(Color.red);
        g.setFont(FONT_TIME_MED);
        g.drawString("Ls " + nFormat3.format(marsTime.getSolarLongitude()) + "\u00b0", col2x + 5, col2y + 36);
        g.drawString("MSD " + nFormat3.format(marsTime.getMarsSolDate()), col2x + 5, col2y + 54);
        g.drawString(marsTime.getSeason(this.timeSiteLat >= 0.0), col2x + 5, col2y + 72);
        g.setColor(Color.green);
        g.setFont(FONT_TIME_LRG);
        g.drawString(mTimestrBuffer.toString(), col3x + 5, col3y + 21);
        g.setColor(Color.red);
        g.setFont(FONT_TIME_MED);
        g.drawString("at " + nFormat1.format(this.timeSiteLon) + "\u00b0W " + nFormat1.format(this.timeSiteLat) + "\u00b0N", col3x + 5, col3y + 36);
        g.drawString(elevationString, col3x + 5, col3y + 54);
        g.drawString(azimuthString, col3x + 5, col3y + 72);
        if (this.displayChoice > 0 && this.aspectRatio < 1.01) {
            g.drawString("Centered on", 5, col3y + 108);
            g.drawString(nFormat1.format(this.copLon) + "\u00b0W " + nFormat1.format(this.copLat) + "\u00b0N", 5, col3y + 126);
        }
    }

    private void drawMap(Graphics g) {
        if (this.timeNow > this.nextRemapTime) {
            this.shadowMap.setSubsolarPoint(this.subsolarLon, this.subsolarLat);
            this.nextRemapTime = this.timeNow + 20000L;
            if (this.timeMethod == 2) {
                this.nextRemapTime += 30000000L;
            }
        }
        Image mapImage = this.shadowMap.getMap();
        if (this.bigProjectionImage == (Image)null) {
            this.bigProjectionImage = this.createImage(720, 360);
            this.smallProjectionImage = this.createImage(364, 364);
            this.projectionChanged = true;
            this.projectionNeedsRedraw = true;
        }
        if (this.projectionChanged) {
            this.theProjection = this.aspectRatio > 1.0 ? new Projection(this.projectionChoice, 720, 360, this.copLon, this.copLat) : new Projection(this.projectionChoice, 720, 360, 364, 364, this.copLon, this.copLat);
            this.theProjection.setBackgroundColor(Color.black);
            this.theProjection.setGridColor(new Color(204, 255, 204));
            this.theProjection.setGridLabeled(true);
            this.projectionChanged = false;
            this.projectionNeedsRedraw = true;
        }
        Graphics projectionGfx = this.aspectRatio > 1.0 ? this.bigProjectionImage.getGraphics() : this.smallProjectionImage.getGraphics();
        if (this.projectionNeedsRedraw) {
            if (this.showLLGrid) {
                this.theProjection.drawMap(mapImage, projectionGfx, 30);
            } else {
                this.theProjection.drawMap(mapImage, projectionGfx);
            }
            this.projectionNeedsRedraw = false;
        }
        if (this.aspectRatio > 1.0) {
            g.drawImage(this.bigProjectionImage, 0, 0, this);
        } else {
            g.drawImage(this.smallProjectionImage, this.offsetX, this.offsetY, this);
        }
        if (this.showSubsolar) {
            this.markSpot(g, this.subsolarLon, this.subsolarLat, 1, Color.red, Color.yellow);
            this.markSpot(g, this.timeSiteLon, this.timeSiteLat, 0, Color.white);
        }
        if (this.showLanders) {
            int i = 0;
            while (i < this.landmarks.count()) {
                Landmark l = this.landmarks.getElement(i);
                if (l.getType() == 2 || l.getType() == 1) {
                    this.markSpot(g, l.getLongitude(), l.getLatitude(), 0, l.getColor(), l.getCode());
                }
                ++i;
            }
        }
    }

    private void markSpot(Graphics g, double lon, double lat) {
        this.markSpot(g, lon, lat, 0, Color.white, null, "");
    }

    private void markSpot(Graphics g, double lon, double lat, Color color) {
        this.markSpot(g, lon, lat, 0, color, null, "");
    }

    private void markSpot(Graphics g, double lon, double lat, int shape, Color color) {
        this.markSpot(g, lon, lat, shape, color, null, "");
    }

    private void markSpot(Graphics g, double lon, double lat, int shape, Color lineColor, Color fillColor) {
        this.markSpot(g, lon, lat, shape, lineColor, fillColor, "");
    }

    private void markSpot(Graphics g, double lon, double lat, int shape, Color lineColor, String label) {
        this.markSpot(g, lon, lat, shape, lineColor, null, label);
    }

    private void markSpot(Graphics g, double lon, double lat, int shape, Color lineColor, Color fillColor, String label) {
        if (this.theProjection == null) {
            return;
        }
        Point xy = this.theProjection.transformLL2XY(lon, lat);
        if (xy == null) {
            return;
        }
        int x = xy.x + this.offsetX;
        int y = xy.y + this.offsetY;
        if (shape == 0) {
            g.setColor(lineColor);
            g.drawLine(x - 2, y, x + 2, y);
            g.drawLine(x, y - 2, x, y + 2);
        } else if (shape == 1) {
            if (fillColor != null) {
                g.setColor(fillColor);
                g.fillOval(x - 3, y - 3, 6, 6);
            }
            g.setColor(lineColor);
            g.drawOval(x - 3, y - 3, 6, 6);
        }
        if (label.length() > 0) {
            g.setColor(lineColor);
            g.setFont(FONT_LABELS);
            g.drawString(label, x + 2, y - 2);
        }
    }

    private void drawHorizon(Graphics g, MarsTime mTime0) {
        if (this.horizonPlotter == null) {
            this.horizonPlotter = new M24HorizonPlotter(720, 444);
        }
        if (this.horizonNeedsUpdate || this.timeNow > this.nextRemapTime) {
            this.horizonPlotter.draw(this.offscreenHorizon.getGraphics(), mTime0, this.timeSiteLon, this.timeSiteLat, this.horizonDirect == 1);
            this.nextRemapTime = this.timeNow + 10000L;
            if (this.timeMethod == 2) {
                this.nextRemapTime += 30000000L;
            }
            this.horizonNeedsUpdate = false;
        }
        g.drawImage(this.offscreenHorizon, 0, 0, this);
    }

    private void drawOrbit(Graphics g, MarsTime mTime0, EarthTime eTime0) {
        if (this.orbitPlotter == null) {
            this.orbitPlotter = new M24OrbitPlotter(720, 444);
        }
        if (this.orbitNeedsUpdate || this.timeNow > this.nextRemapTime) {
            this.orbitPlotter.draw(this.offscreenOrbit.getGraphics(), this.timeMillis, mTime0, eTime0);
            this.nextRemapTime = this.timeNow + 10000L;
            if (this.timeMethod == 2) {
                this.nextRemapTime += 30000000L;
            }
            this.orbitNeedsUpdate = false;
        }
        g.drawImage(this.offscreenOrbit, 0, 0, this);
    }

    private String getLightTime(MarsTime marsTime, EarthTime earthTime) {
        double rM = marsTime.getHeliocentricDistance();
        double rE = earthTime.getHeliocentricDistance();
        double lambdaM = marsTime.getHeliocentricLongitude();
        double lambdaE = earthTime.getHeliocentricLongitude();
        double psiM = marsTime.getHeliocentricLatitude();
        double angle = Mathlib.toRadians(lambdaM - lambdaE);
        double distAU = Math.sqrt(rE * rE + rM * rM - 2.0 * rE * rM * Math.cos(angle) * Math.cos(Mathlib.toRadians(psiM)));
        double distLight = distAU * 499.00478;
        int isec = (int)Math.round(distLight);
        int isecX = isec % 60;
        int iminX = (isec - isecX) / 60;
        return iminX + ":" + FORMAT02.format(isecX);
    }

    static {
        nFormat1.setMinimumFractionDigits(1);
        nFormat1.setMaximumFractionDigits(1);
        nFormat3.setGroupingUsed(false);
        nFormat3.setMinimumFractionDigits(2);
        nFormat3.setMaximumFractionDigits(2);
        nFormat3.setGroupingUsed(false);
        nFormat3.setMinimumFractionDigits(3);
        nFormat3.setMaximumFractionDigits(3);
        nFormat3.setGroupingUsed(false);
    }
}

