/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mars24.LandmarkList;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.application.M24ControlsFrame;
import gov.nasa.giss.mars24.application.M24ControlsPanel;
import gov.nasa.giss.mars24.application.M24DisplayFrame;
import gov.nasa.giss.mars24.application.M24ForMac;
import gov.nasa.giss.mars24.application.M24Globals;
import gov.nasa.giss.mars24.application.M24PlotPanel;
import gov.nasa.giss.mars24.application.M24TimePanel;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class Mars24 {
    private static boolean isMacOS = false;
    private static final String MAP_FILE = "marsmap.jpg";
    private static final String LANDMARK_FILE = "marslandmarks.xml";

    public static void main(String[] args) {
        new Mars24();
    }

    public Mars24() {
        File f;
        String sep;
        String path;
        int isep;
        if (System.getProperty("mrj.version") != null) {
            isMacOS = true;
            M24ForMac.register();
        }
        path = (isep = (path = System.getProperty("java.class.path")).lastIndexOf(sep = System.getProperty("file.separator"))) > -1 ? path.substring(0, isep) : ".";
        ImageIcon ii = null;
        try {
            File f2 = new File(path, MAP_FILE);
            if (f2.exists()) {
                ii = new ImageIcon(path + sep + MAP_FILE);
            }
        }
        catch (Exception exc) {
            ii = null;
        }
        LandmarkList landmarks = null;
        try {
            f = new File(path, LANDMARK_FILE);
            if (f.exists()) {
                landmarks = new LandmarkList(f);
            }
        }
        catch (Exception exc) {
            landmarks = null;
        }
        if (isMacOS && ii == null) {
            path = System.getProperty("user.dir");
            try {
                f = new File(path, MAP_FILE);
                if (f.exists()) {
                    ii = new ImageIcon(path + sep + MAP_FILE);
                }
            }
            catch (Exception exc) {
                ii = null;
            }
        }
        if (isMacOS && landmarks == null) {
            path = System.getProperty("user.dir");
            try {
                f = new File(path, LANDMARK_FILE);
                if (f.exists()) {
                    landmarks = new LandmarkList(f);
                }
            }
            catch (Exception exc) {
                landmarks = null;
            }
        }
        if (ii == null) {
            try {
                ii = new ImageIcon(this.getClass().getResource(MAP_FILE));
            }
            catch (Exception exc) {
                System.out.println("Could not find map image file.");
                System.exit(0);
            }
        }
        if (landmarks == null) {
            try {
                landmarks = new LandmarkList(this.getClass().getResource(LANDMARK_FILE));
            }
            catch (Exception exc) {
                landmarks = new LandmarkList();
            }
        }
        UIDefaults uid = UIManager.getDefaults();
        this.reduceFont(uid, "Button");
        this.reduceFont(uid, "CheckBox");
        this.reduceFont(uid, "ComboBox");
        this.reduceFont(uid, "Label");
        this.reduceFont(uid, "RadioButton");
        this.reduceFont(uid, "TextArea");
        this.reduceFont(uid, "TextField");
        this.reduceFont(uid, "TitledBorder");
        M24Timekeeper tk = new M24Timekeeper(landmarks);
        Rectangle rr = M24Globals.getMainScreenBounds();
        int ppWidth = 25;
        if (rr != null) {
            ppWidth = rr.width - 80;
        }
        M24PlotPanel plotPanel = new M24PlotPanel(tk, ppWidth, ppWidth / 2, landmarks, ii.getImage());
        M24TimePanel timePanel = new M24TimePanel(tk);
        M24ControlsPanel controlsPanel = new M24ControlsPanel(tk, plotPanel, timePanel, landmarks);
        new M24DisplayFrame("Mars24 - Sunclock", plotPanel, 0, 1);
        new M24DisplayFrame("Mars24 - Time", timePanel, 2, 3);
        new M24ControlsFrame(controlsPanel);
        if (!isMacOS) {
            Runnable frameWatcher = new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(3000L);
                            Frame[] f = Frame.getFrames();
                            int i = 0;
                            while (i < f.length) {
                                if (f[i].isVisible()) {
                                    return;
                                }
                                ++i;
                            }
                            System.out.println("no frames visible -> exit");
                            System.exit(0);
                            continue;
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            Thread t = new Thread(frameWatcher, "FrameWatcher");
            t.start();
        }
    }

    private void reduceFont(UIDefaults uid, String pname) {
        Font f = uid.getFont(pname + ".font");
        if (f != null) {
            uid.put(pname + ".font", f.deriveFont((float)((double)f.getSize() - 1.0)));
        }
    }
}

