/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mars24.Landmark;
import gov.nasa.giss.mars24.LandmarkList;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.time.EarthTime;
import gov.nasa.giss.time.JulianDate;
import gov.nasa.giss.time.MarsTime;
import java.util.Date;
import javax.swing.event.EventListenerList;

public class M24Timekeeper {
    public static final int CURRENT = 1;
    public static final int OFFSET = 2;
    public static final int FIXED = 3;
    public static final long BAD_OFFSET = Long.MIN_VALUE;
    private int method = 1;
    private double siteLon = 0.0;
    private double siteLat = 0.0;
    private double zoneLon = 0.0;
    private JulianDate julianTime = new JulianDate(0L);
    private MarsTime marsTime = new MarsTime(0L);
    private EarthTime earthTime = new EarthTime(0L);
    private long millis;
    private long nowMillis;
    private long offsetMillis;
    private Date fixedDate = new Date();
    private boolean badTime = false;
    private boolean showDateAsDOY = false;
    private LandmarkList landmarks;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$gov$nasa$giss$mars24$M24TimekeeperListener;

    public M24Timekeeper(LandmarkList ll) {
        this.landmarks = ll;
    }

    public int getMethod() {
        return this.method;
    }

    public void setShowCurrent() {
        this.method = 1;
        this.badTime = false;
        this.fireTimeChanged();
    }

    public void setShowOffset(long m) {
        this.method = 2;
        this.badTime = false;
        if (m == Long.MIN_VALUE) {
            this.badTime = true;
        } else {
            this.offsetMillis = m;
        }
        this.fireTimeChanged();
    }

    public void setShowFixed(String s) {
        this.method = 3;
        this.badTime = false;
        try {
            this.fixedDate = new Date(s + " GMT");
            int year = this.fixedDate.getYear() + 1900;
            if (year < 1750 || year > 2250) {
                this.badTime = true;
            }
        }
        catch (Exception exc) {
            this.badTime = true;
        }
        this.fireTimeChanged();
    }

    public boolean getShowDateAsDOY() {
        return this.showDateAsDOY;
    }

    public void setShowDateAsDOY(boolean b) {
        if (b == this.showDateAsDOY) {
            return;
        }
        this.showDateAsDOY = b;
    }

    public double getSiteLongitude() {
        return this.siteLon;
    }

    public double getSiteLatitude() {
        return this.siteLat;
    }

    public double getZoneLongitude() {
        return this.zoneLon;
    }

    public void setLandmarkSite(String id) {
        int i = 0;
        while (i < this.landmarks.count()) {
            Landmark l = this.landmarks.getElement(i);
            if (l.getCode().equals(id)) {
                this.setSite(l.getLongitude(), l.getLatitude());
                break;
            }
            ++i;
        }
    }

    public void setSite(double lon, double lat) {
        if (lon == this.siteLon && lat == this.siteLat) {
            return;
        }
        this.siteLon = lon;
        this.siteLat = lat;
        this.zoneLon = 15.0 * (double)((int)((this.siteLon + 7.5) / 15.0));
        this.fireSiteChanged();
    }

    public void setSite(String xString, String yString) {
        try {
            double lon = Double.valueOf(xString);
            double lat = Double.valueOf(yString);
            while (lat > 90.0) {
                lat -= 180.0;
            }
            while (lat < -90.0) {
                lat += 180.0;
            }
            while (lon > 360.0) {
                lon -= 360.0;
            }
            while (lon < 0.0) {
                lon += 360.0;
            }
            this.setSite(lon, lat);
        }
        catch (Exception exc) {
            System.out.println("setSite error : " + exc.toString());
        }
    }

    public long getMillis() {
        this.update();
        if (this.badTime) {
            return 0L;
        }
        return this.millis;
    }

    public JulianDate getJulianDate() {
        this.update();
        if (this.badTime) {
            return null;
        }
        return this.julianTime;
    }

    public MarsTime getMarsTime() {
        this.update();
        if (this.badTime) {
            return null;
        }
        return this.marsTime;
    }

    public EarthTime getEarthTime() {
        this.update();
        if (this.badTime) {
            return null;
        }
        return this.earthTime;
    }

    private void update() {
        this.nowMillis = System.currentTimeMillis();
        this.millis = this.method == 2 ? this.nowMillis + this.offsetMillis : (this.method == 3 ? this.fixedDate.getTime() : this.nowMillis);
        this.julianTime.setTime(this.millis);
        this.marsTime.setTime(this.millis);
        this.earthTime.setTime(this.millis);
    }

    public synchronized void addTimekeeperListener(M24TimekeeperListener l) {
        this.listenerList.add(class$gov$nasa$giss$mars24$M24TimekeeperListener == null ? (class$gov$nasa$giss$mars24$M24TimekeeperListener = M24Timekeeper.class$("gov.nasa.giss.mars24.M24TimekeeperListener")) : class$gov$nasa$giss$mars24$M24TimekeeperListener, l);
    }

    public synchronized void removeTimekeeperListener(M24TimekeeperListener l) {
        this.listenerList.remove(class$gov$nasa$giss$mars24$M24TimekeeperListener == null ? (class$gov$nasa$giss$mars24$M24TimekeeperListener = M24Timekeeper.class$("gov.nasa.giss.mars24.M24TimekeeperListener")) : class$gov$nasa$giss$mars24$M24TimekeeperListener, l);
    }

    protected void fireTimeChanged() {
        M24TimekeeperEvent e = new M24TimekeeperEvent(this, 1);
        Object[] list = this.listenerList.getListenerList();
        int i = 0;
        while (i < list.length) {
            if (list[i] instanceof M24TimekeeperListener) {
                ((M24TimekeeperListener)list[i]).timeChanged(e);
            }
            ++i;
        }
    }

    protected void fireSiteChanged() {
        M24TimekeeperEvent e = new M24TimekeeperEvent(this, 2);
        Object[] list = this.listenerList.getListenerList();
        int i = 0;
        while (i < list.length) {
            if (list[i] instanceof M24TimekeeperListener) {
                ((M24TimekeeperListener)list[i]).siteChanged(e);
            }
            ++i;
        }
    }

    protected void fireFormatChanged() {
        M24TimekeeperEvent e = new M24TimekeeperEvent(this, 3);
        Object[] list = this.listenerList.getListenerList();
        int i = 0;
        while (i < list.length) {
            if (list[i] instanceof M24TimekeeperListener) {
                ((M24TimekeeperListener)list[i]).timeChanged(e);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

