/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mars24.LandmarkEvent;
import gov.nasa.giss.mars24.LandmarkListener;
import java.awt.Color;
import javax.swing.event.EventListenerList;

public class Landmark {
    public static final int LANDER = 2;
    public static final int PLANNED = 1;
    public static final int CRASHSITE = 3;
    public static final int FEATURE = 4;
    public static final int UNKNOWN = 99;
    private double longitude;
    private double latitude;
    private boolean marked;
    private int type;
    private String code;
    private String name;
    private Color color;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$gov$nasa$giss$mars24$LandmarkListener;

    public Landmark(int type, double lon, double lat, String code, String name) {
        this(type, lon, lat, code, name, Color.green);
    }

    public Landmark(int type, double lon, double lat, String code, String name, Color color) {
        this.type = type;
        this.longitude = lon;
        this.latitude = lat;
        this.marked = this.marked;
        this.code = code;
        this.name = name;
        this.color = color;
    }

    public int getType() {
        return this.type;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean b) {
        if (b != this.marked) {
            this.marked = b;
            this.fireStateChanged();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int compareTo(Landmark other) {
        if (this.type > other.type) {
            return 1;
        }
        if (this.type < other.type) {
            return -1;
        }
        return this.name.compareTo(other.name);
    }

    public synchronized void addLandmarkListener(LandmarkListener l) {
        this.listenerList.add(class$gov$nasa$giss$mars24$LandmarkListener == null ? (class$gov$nasa$giss$mars24$LandmarkListener = Landmark.class$("gov.nasa.giss.mars24.LandmarkListener")) : class$gov$nasa$giss$mars24$LandmarkListener, l);
    }

    public synchronized void removeLandmarkListener(LandmarkListener l) {
        this.listenerList.remove(class$gov$nasa$giss$mars24$LandmarkListener == null ? (class$gov$nasa$giss$mars24$LandmarkListener = Landmark.class$("gov.nasa.giss.mars24.LandmarkListener")) : class$gov$nasa$giss$mars24$LandmarkListener, l);
    }

    protected void fireStateChanged() {
        LandmarkEvent e = new LandmarkEvent(this, 1);
        Object[] list = this.listenerList.getListenerList();
        int i = 0;
        while (i < list.length) {
            if (list[i] instanceof LandmarkListener) {
                ((LandmarkListener)list[i]).stateChanged(e);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

