/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class Wagner1
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Wagner I";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double FOURTHROOTOF3 = Math.sqrt(Math.sqrt(3.0));
    private static final double TERM_N = 0.5 * Math.sqrt(3.0);
    private static final double CSUBX = 2.0 * FOURTHROOTOF3 / 3.0;
    private static final double CSUBY = 1.0 / CSUBX;
    private static final double CSUBY_OVER_N = CSUBY / TERM_N;
    private static final double FIT_WIDTH = CSUBX * Math.PI;
    private static final double FIT_HEIGHT = CSUBY * Math.asin(TERM_N) / TERM_N;
    public static final double ASPECT_RATIO = FIT_WIDTH / FIT_HEIGHT;
    private double scaleFactor = 1.0;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public Wagner1(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public Wagner1(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public Wagner1(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / FIT_HEIGHT, 0.5 * (double)this.useWidth / FIT_WIDTH);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int y = 0;
        while ((double)y < 0.5 * (double)this.useHeight) {
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            double thetaRad = this.oneOverRS * (double)y / CSUBY_OVER_N;
            double phiRad = Math.asin(Math.sin(thetaRad) / TERM_N);
            double phi = AbstractProjection.toDegrees(phiRad);
            if (phi > 90.0 || phi < -90.0) break;
            int yMap = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int yMapF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = this.oneOverRS / (CSUBX * Math.cos(thetaRad));
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = -AbstractProjection.toDegrees((double)x * xFactor);
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xMap = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xMapF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMapF >= this.srcWidth) {
                    xMapF -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                while (xMapF < 0) {
                    xMapF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                this.invArray[row * this.dstWidth + colF] = yMap * this.srcWidth + xMapF;
                this.invArray[rowF * this.dstWidth + col] = yMapF * this.srcWidth + xMap;
                this.invArray[rowF * this.dstWidth + colF] = yMapF * this.srcWidth + xMapF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double longitude, double latitude) {
        double phiRad = AbstractProjection.toRadians(latitude);
        double thetaRad = Math.asin(TERM_N * Math.sin(phiRad));
        double dlambda = longitude - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double x = -this.rS * CSUBX * AbstractProjection.toRadians(dlambda) * Math.cos(thetaRad);
        double y = this.rS * CSUBY_OVER_N * thetaRad;
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

