/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class PutninsP5
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Putni\u0146\u0161 P5";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERM_X = 1.01346;
    private static final double TERM_A = 2.0;
    private static final double TERM_B = 1.0;
    private static final double ONE_OVER_X = 0.9867187654174807;
    private static final double TWELVE_OVER_PI_SQUARE = 1.2158542037080533;
    private static final double FIT_WIDTH = 3.183878490707112;
    private static final double FIT_HEIGHT = 1.591939245353556;
    public static final double ASPECT_RATIO = 2.0;
    private double scaleFactor = 1.0;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public PutninsP5(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public PutninsP5(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public PutninsP5(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / 1.591939245353556, 0.5 * (double)this.useWidth / 3.183878490707112);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int y = 0;
        while ((double)y < 0.5 * (double)this.useHeight) {
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            double phiRad = (double)y * this.oneOverRS * 0.9867187654174807;
            double phi = AbstractProjection.toDegrees(phiRad);
            if (phi > 90.0 || phi < -90.0) break;
            int yMap = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int yMapF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = 0.9867187654174807 * this.oneOverRS / (2.0 - 1.0 * Math.sqrt(1.0 + 1.2158542037080533 * phiRad * phiRad));
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = -AbstractProjection.toDegrees((double)x * xFactor);
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xMap = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xMapF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMapF >= this.srcWidth) {
                    xMapF -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                while (xMapF < 0) {
                    xMapF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                this.invArray[row * this.dstWidth + colF] = yMap * this.srcWidth + xMapF;
                this.invArray[rowF * this.dstWidth + col] = yMapF * this.srcWidth + xMap;
                this.invArray[rowF * this.dstWidth + colF] = yMapF * this.srcWidth + xMapF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double lon, double lat) {
        double phiRad = AbstractProjection.toRadians(lat);
        double dlambda = lon - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double x = -this.rS * 1.01346 * AbstractProjection.toRadians(dlambda) * (2.0 - 1.0 * Math.sqrt(1.0 + 1.2158542037080533 * phiRad * phiRad));
        double y = this.rS * 1.01346 * phiRad;
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

