/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class FlatPolarParabolic
extends AbstractProjection {
    private static final String PROJECTION_NAME = "M.T. Flat-Polar Parabolic";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERM1 = 3.0 * Math.sqrt(6.0);
    private static final double TERM2 = Math.sqrt(0.8571428571428571);
    private static final double ONE_OVER_TERM2 = 1.0 / TERM2;
    private static final double TERM3 = 9.0 / Math.sqrt(7.0);
    private static final double FIT_WIDTH = TERM2 * Math.PI;
    private static final double FIT_HEIGHT = Math.sin(Math.asin(7.0 / TERM1) / 3.0) * 9.0 / Math.sqrt(7.0);
    public static final double ASPECT_RATIO = FIT_WIDTH / FIT_HEIGHT;
    private double scaleFactor = 1.0;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public FlatPolarParabolic(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public FlatPolarParabolic(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public FlatPolarParabolic(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / FIT_HEIGHT, 0.5 * (double)this.useWidth / FIT_WIDTH);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int maxY = (int)(0.5 + FIT_HEIGHT * this.radius);
        if (maxY > this.yCenter) {
            maxY = this.yCenter;
        }
        int y = 0;
        while (y < maxY) {
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            double thetaRad = 3.0 * Math.asin((double)y * this.oneOverRS / TERM3);
            double sinTheta = Math.sin(thetaRad);
            double phi = AbstractProjection.toDegrees(Math.asin(sinTheta * TERM1 / 7.0));
            if (phi > 90.0 || phi < -90.0) break;
            int yMap = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int yMapF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = this.oneOverRS * ONE_OVER_TERM2 / (2.0 * Math.cos(2.0 * thetaRad / 3.0) - 1.0);
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = -AbstractProjection.toDegrees((double)x * xFactor);
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xMap = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xMapF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMapF >= this.srcWidth) {
                    xMapF -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                while (xMapF < 0) {
                    xMapF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                this.invArray[row * this.dstWidth + colF] = yMap * this.srcWidth + xMapF;
                this.invArray[rowF * this.dstWidth + col] = yMapF * this.srcWidth + xMap;
                this.invArray[rowF * this.dstWidth + colF] = yMapF * this.srcWidth + xMapF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double longitude, double latitude) {
        double thetaRad = Math.asin(7.0 * Math.sin(AbstractProjection.toRadians(latitude)) / TERM1);
        double dlambda = longitude - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double x = -this.rS * TERM2 * AbstractProjection.toRadians(dlambda) * (2.0 * Math.cos(2.0 * thetaRad / 3.0) - 1.0);
        double y = this.rS * TERM3 * Math.sin(thetaRad / 3.0);
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

