/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class AzimEquidistant
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Azimuthal Equidistant";
    private static final boolean IS_AZIMUTHAL = true;
    private static final double FIT_FACTOR = 1.5707963267948966;
    public static final double ASPECT_RATIO = 1.0;
    private double scaleFactor = 1.0;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;
    private double r2s2;
    private double rhoMax;
    private double rhoMax2;

    public AzimEquidistant(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0, 45.0);
    }

    public AzimEquidistant(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude, Double latitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude, (double)latitude);
    }

    public AzimEquidistant(int dw, int dh, int xm, int ym, double longitude, double latitude) {
        this.init(dw, dh, xm, ym, longitude, latitude);
        int useWidth = this.dstWidth - 2 * this.xMargin;
        int useHeight = this.dstHeight - 2 * this.yMargin;
        this.radius = Math.min(0.5 * (double)useHeight / 1.5707963267948966, 0.5 * (double)useWidth / 1.5707963267948966);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
        this.r2s2 = this.rS * this.rS;
        this.rhoMax = 0.5 * (double)Math.min(useHeight, useWidth);
        this.rhoMax2 = this.rhoMax * this.rhoMax;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return true;
    }

    public static double getAspectRatio() {
        return 1.0;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int row = this.yMargin;
        while (row < this.dstHeight - this.yMargin) {
            double y = this.yCenter - row;
            double y2 = y * y;
            int col = this.xMargin;
            while (col < this.dstWidth - this.yMargin) {
                double x = col - this.xCenter;
                double rho = Math.sqrt(x * x + y2);
                if (!(rho > this.rhoMax)) {
                    double dlambdaRad;
                    double phiRad;
                    if (rho > 0.0) {
                        double c = rho * this.oneOverRS;
                        double sinC = Math.sin(c);
                        double cosC = Math.cos(c);
                        phiRad = Math.asin(cosC * this.sinCOPLat + y * sinC * this.cosCOPLat / rho);
                        dlambdaRad = Math.atan2(x * sinC, rho * this.cosCOPLat * cosC - y * this.sinCOPLat * sinC);
                    } else {
                        phiRad = AbstractProjection.toRadians(this.copLat);
                        dlambdaRad = 0.0;
                    }
                    int yMap = (int)(this.srcXPixPerDeg * (90.0 - AbstractProjection.toDegrees(phiRad)));
                    int xMap = (int)(this.srcXPixPerDeg * (180.0 + AbstractProjection.toDegrees(dlambdaRad) - this.copLon));
                    while (xMap >= this.srcWidth) {
                        xMap -= this.srcWidth;
                    }
                    while (xMap < 0) {
                        xMap += this.srcWidth;
                    }
                    this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                }
                ++col;
            }
            ++row;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double lon, double lat) {
        double dlambdaRad = AbstractProjection.toRadians(this.copLon - lon);
        double cosDLambda = Math.cos(dlambdaRad);
        double cosLat = Math.cos(AbstractProjection.toRadians(lat));
        double sinLat = Math.sin(AbstractProjection.toRadians(lat));
        double c = Math.acos(this.sinCOPLat * sinLat + this.cosCOPLat * cosLat * Math.cos(dlambdaRad));
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(c) < 1.0E-5) {
            x = 0.0;
            y = 0.0;
        } else {
            double k = c / Math.sin(c);
            x = this.rS * k * cosLat * Math.sin(dlambdaRad);
            if (x * x + (y = this.rS * k * (this.cosCOPLat * sinLat - this.sinCOPLat * cosLat * cosDLambda)) * y > this.rhoMax2) {
                return null;
            }
        }
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

