/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colorbar;

import gov.nasa.giss.graphics.colorbar.AbstractColorbar;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class ACTColorbar
extends AbstractColorbar {
    public ACTColorbar(File f) throws IOException, FileNotFoundException {
        super(f);
        byte[] b = this.readBytes(f, 768, 772);
        this.fillColorTable(b);
    }

    public ACTColorbar(URL url) throws IOException, FileNotFoundException {
        super(url);
        byte[] b = this.readBytes(url, 768, 772);
        this.fillColorTable(b);
    }

    public ACTColorbar(byte[] b, String identifier) throws IOException {
        this.identifier = identifier;
        this.makeName(identifier);
        this.fillColorTable(b);
    }

    private void fillColorTable(byte[] b) throws IOException {
        int i;
        if (b.length < 768) {
            throw new IOException("Not a valid ACT color table");
        }
        this.colorCount = 256;
        this.minBin = 0;
        this.maxBin = 255;
        this.colorCount = 256;
        if (b.length == 772 && (i = ((short)b[768] << 8) + b[769]) > 0) {
            this.colorCount = i;
        }
        this.maxBin = this.colorCount - 1;
        this.minOutlierBin = this.minBin;
        this.maxOutlierBin = this.maxBin;
        this.colors = new Color[this.colorCount];
        this.rgbValues = new int[this.colorCount];
        i = 0;
        while (i < this.colorCount) {
            this.colors[i] = new Color(0xFF & b[i * 3], 0xFF & b[i * 3 + 1], 0xFF & b[i * 3 + 2]);
            this.rgbValues[i] = this.colors[i].getRGB();
            ++i;
        }
    }

    public String getName() {
        return super.getName() + " ACT";
    }
}

