/*
 * Decompiled with CFR 0.152.
 */
package tokens;

import eserver.IEngineServer;
import structures.MacroList;
import tokens.IMacroIO;
import tokens.Macro;

public class MacroManager {
    protected MacroList m_list;
    protected IMacroIO m_macroIO;
    protected IEngineServer m_server;

    public MacroManager(IMacroIO iMacroIO) {
        this.m_macroIO = iMacroIO;
        this.loadMacros();
    }

    public void loadMacros() {
        this.m_list = new MacroList(this.m_macroIO.readMacros());
    }

    public void loadMacros(String string) {
        if (string != null) {
            this.m_macroIO.setMacroFile(string);
            this.m_list = new MacroList(this.m_macroIO.readMacros());
        }
    }

    public void saveMacros() {
        if (this.m_list != null) {
            this.m_macroIO.saveMacros(this.m_list.toStrings());
        }
    }

    public void saveMacros(String string) {
        if (string != null) {
            this.m_macroIO.setMacroFile(string);
            if (this.m_list != null) {
                this.m_macroIO.saveMacros(this.m_list.toStrings());
            }
        }
    }

    public void removeMacro(String string) {
        this.m_list = this.m_list.removeMacro(string);
    }

    public void addMacro(String string, String string2) {
        this.m_list = this.m_list.addMacro(new Macro(string, string2));
    }

    public void addMacro(Macro macro) {
        this.m_list = this.m_list.addMacro(macro);
    }

    public void replaceMacro(String string, String string2) {
        this.m_list = this.m_list.addMacro(new Macro(string, string2));
    }

    public boolean macroExists(String string) {
        return this.m_list.macroExists(string);
    }

    public MacroList getMacroList() {
        return this.m_list;
    }

    public void setServer(IEngineServer iEngineServer) {
        this.m_server = iEngineServer;
    }

    public IEngineServer getServer() {
        return this.m_server;
    }

    public void verifyMacros() {
        this.m_list = this.m_list.verifyMacros(this.m_server);
    }

    public int numberOfMacros() {
        return this.m_list.length();
    }

    public String getMacroFile() {
        return this.m_macroIO.getMacroFile();
    }
}

