/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.presentation.component;

import com.edsdev.jconvert.common.CustomConversionDataInterface;
import com.edsdev.jconvert.common.CustomDataUpdatedListener;
import com.edsdev.jconvert.presentation.ConversionPanel;
import com.edsdev.jconvert.presentation.ConversionTypeData;
import com.edsdev.jconvert.util.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CustomTabConversionPanel
extends ConversionPanel
implements CustomDataUpdatedListener {
    private CustomConversionDataInterface customAdapter = null;
    private static JLabel timeLabel = null;

    private CustomTabConversionPanel(ConversionTypeData conversionTypeData) {
        super(conversionTypeData);
    }

    public CustomTabConversionPanel(CustomConversionDataInterface customConversionDataInterface) {
        this(new ConversionTypeData(customConversionDataInterface.getConversions()));
        this.setCustomDataAdapter(customConversionDataInterface);
        timeLabel.setText(this.getLastUpdateTimestamp());
    }

    public void setCustomDataAdapter(CustomConversionDataInterface customConversionDataInterface) {
        this.customAdapter = customConversionDataInterface;
        this.customAdapter.addDataUpdatedListener(this);
    }

    private String getLastUpdateTimestamp() {
        if (this.customAdapter == null) {
            return "";
        }
        Date date = this.customAdapter.getLastUpdated();
        if (date == null) {
            return "";
        }
        return date.toLocaleString();
    }

    private void updateData() {
        ConversionTypeData conversionTypeData = new ConversionTypeData(this.customAdapter.getConversions());
        this.setConversionTypeData(conversionTypeData);
        timeLabel.setText(this.getLastUpdateTimestamp());
    }

    protected Component getTopComponent() {
        JPanel jPanel = new JPanel();
        Dimension dimension = new Dimension(1500, 30);
        jPanel.setPreferredSize(dimension);
        jPanel.setMaximumSize(dimension);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton(Messages.getResource("updateDataButton"));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTabConversionPanel.this.updateData();
            }
        });
        JLabel jLabel = new JLabel(Messages.getResource("lastUpdateTime"));
        jLabel.setMaximumSize(new Dimension(100, 22));
        jPanel.add(jLabel);
        timeLabel = new JLabel(this.getLastUpdateTimestamp());
        jPanel.add(timeLabel);
        return jPanel;
    }

    public void customDataUpdated() {
        this.updateData();
    }
}

