#include<stdlib.h>
#include<string.h>
#include<ctype.h>
#include"wir.h"

const struct dir_entry far*dir;
char*sortopt=NULL,*pathterm=truename+3,*cand=NULL;
unsigned flags=DEFAULT_FLAGS;
int nc=0;
#pragma option -a-
struct COUNTRY countryinfo;
struct dpb dpb;
char truename[128],attrib=0,mask=FA_SYSTEM|FA_HIDDEN|FA_LABEL,drive;
#pragma option -a
void error(const char*m)
{
  fprintf(stderr,"%s.\n",m);
  exit(1);
}

void usage(void)
{
  printf("Usage:\tWIR [drive:][path][filename] [/3] [/4] [/A[adshr]] [/LFN] "
	 "[/NU] [/L]\n\t    [/O[nedsg]] [/B] [/F] %s[/JA] [/NEC] [/IGNSUM] "
	 "[/?]\n",flags&OS2?"[/N] [/EA] ":"");
}

int getabit(int c,char*bp)
{
  const static struct t{
    char c,b;
  }t[]={
    {'A',FA_ARCH  },{'D',FA_DIREC },{'S',FA_SYSTEM},
    {'H',FA_HIDDEN},{'R',FA_RDONLY},{  0,	 0}
  };
  const struct t*p=t;
  c=toupper(c);
  do
    if(p->c==c){
      *bp|=p->b;
      return 0;
    }
  while((++p)->c);

  return-1;
}

unsigned getflagbit(char**argp)
{
#pragma option -a-
  const static struct t{
    char    *s;
    unsigned b;
    char     n;
  }t[]={
    {"NU",DOCONLY,2},{"NEC",NEC,3},{"N",N,1},{"LONGNAME",LFN,8},{"LONG",LFN,4},
    {"LFN",LFN,3},{"L",L,1},{"JA",JAPANESE,2},{"IGNSUM",IGNSUM,6},{"F",FQ,1},
    {"EA",EA,2},{"B",TWOFIELDS,1},{"4",YEAR4,1},{"3",DIGIT3,1},{NULL,0,0}
  };
#pragma option -a
  const struct t*p=t;
  do
    if(!strnicmp(p->s,*argp,p->n))
      switch(*((*argp)+=p->n)){
	case 0:
	case' ':
	case'/': return p->b;
      }
  while((++p)->s);

  return 0;
}

char*checkopt(char*arg)
{
  switch(toupper(*arg)){
    case'A': for(mask=FA_LABEL,attrib=0;;)
	       if(getabit(*++arg,&attrib)){
		 if(*arg=='-')
		   if(!getabit(*++arg,&mask))
		     continue;
		 return arg;
	       }
    case'O': if(*(sortopt=++arg))
	       do
		 switch(toupper(*arg)){
		   case'N':
		   case'E':
		   case'D':
		   case'S':
		   case'G': break;

		   case'-': switch(arg[1]){
			      case'-':
			      case 0:  break;
			      default: continue;
			    }
		   default: return arg;
		 }
	       while(*++arg);
	     else
	       sortopt="GNE";
	     break;

    case'-': ++arg;
	     flags&=~getflagbit(&arg);
	     break;

    default: flags|=getflagbit(&arg);
  }
  return arg;
}

int main(int argc,char**argv)
{
  char*target=NULL;
  asm{
    mov ax,4010h; int 2Fh
  }
  if(!_AX)
    flags=DEFAULT_FLAGS|OS2;

  asm{
    mov ax,3800h; lea dx,countryinfo; int 21h
    push ds; mov ax,6300h; int 21h; mov dx,[si]; pop ds
  }
  if(!_AL&&_DX){
    asm{
      mov ax,6601h; xor bx,bx; int 21h
    }
    if(_BX==897||_BX==932||_BX==942||_BX==943)
      flags|=JAPANESE;
  }
  {
    char*wircmd=getenv("WIRCMD");
    if(wircmd)
      for(;*wircmd;wircmd=checkopt(wircmd+1)){
	for(;*wircmd==' ';++wircmd);
	if(*wircmd!='/')
	  break;
      }
  }
  while(--argc>0){
    char*cp;
    if(*(cp=*++argv)=='/')
      do{
	if(*(short*)++cp=='?'){
	  puts("Wir - Version 1.10\n"
	       "Copyright (c) 2000-2001 NBG01720@nifty.ne.jp\n");
	  usage();
	  puts("\nThis program is\t free software;\t you can redistribute it a"
	       "nd/or modify it under\nthe terms of  the GNU General Public Li"
	       "cense  as published by the Free Software\nFoundation; either v"
	       "ersion 2 of the License, or any later version.\n\nThis program"
	       " is distributed in the hope that it will be useful, but WITHOU"
	       "T ANY\nWARRANTY; without even the implied warranty of MERCHANT"
	       "ABILITY or FITNESS FOR A\nPARTICULAR PURPOSE.  See the GNU Gen"
	       "eral Public License for more details.");
	  return 0;
	}
	switch(*(cp=checkopt(cp))){
	  case 0:
	  case'/': break;

	  default: usage();
		   return 1;
	}
      }while(*cp=='/');
    else{
      if(target)
	error("Invalid number of parameters");

      target=cp;
    }
  }
  if((flags&(EA|OS2))==EA)
    error("/EA option is valid only in a OS/2 MVDM session");

  if((flags&(N|OS2))==N)
    fputs("Because /N option is valid only in a OS/2 MVDM session.  "
	  "It is ignored.\n",stderr);

  getdpb(target,truename);
  tracedir(dpb.ndir,truename+3);
  return 0;
}
