#include<sys/stat.h>
#include<io.h>
#include<alloc.h>
#include<stdlib.h>
#include<string.h>
#include<ctype.h>
#include<jctype.h>
#include"wir.h"
/*
 * DOS32StartSessionp̒`
 */
#define SSF_RELATED_INDEPENDENT 0
#define SSF_RELATED_CHILD	1

#define SSF_FGBG_FORE		0
#define SSF_FGBG_BACK		1

#define SSF_TRACEOPT_NONE	0
#define SSF_TRACEOPT_TRACE	1
#define SSF_TRACEOPT_TRACEALL	2
/*
 * ShiftJISΉ strlwr()
 */
void jstrlwr(char*s,int n)
{
  int kanji=flags&JAPANESE&&*s==5;
  if(kanji){
    putchar(0xE5);
    --n;
    ++s;
  }
  for(;--n>=0&&*s;++s)
    if(kanji)
      kanji=0;
    else
      if(!(kanji=flags&JAPANESE&&iskanji(*s)))
	*s=tolower(*s);
}
/* fBNgEGg̃t@C
 * \Ώی̔r
 */
int _fncmp(char*pp,const char far*ep)
{
  int i;

  for(i=11;--i>0;++pp,++ep)
    if(*pp!='?'&&*pp!=*ep)
      return-1;

  return 0;
}

int fncmp(const char far*ep)
{
  int n;

  if(!(n=nc))
    return 0;

  while((n-=11)>=0)
    if(!_fncmp(cand+n,ep))
      return 0;

  return-1;
}
/* fBNgEGg̃t@C
 * gq̕𒲂ׂ邽߂̊֐
 */
int namelen(const char far*name,int n)
{
  while(--n>=0)		/* ̏I肩tɑ	    */
    if(name[n]!=' ')	/* ŏ̋󔒂łȂ̈ʒuԂ */
      break;

  return n+1;
}
/* 3؂̐l\
 */
void print3(int n,unsigned long u,const char*m)
{
  if(flags&DIGIT3){
    int i;
    char*sp,*tp,t[16],s=*countryinfo.co_thsep;
    sp=tp=t;
    sprintf(t+3,"%12lu",u);
    for(i=4;--i>0;){
      *(((long*)tp)++)=*(long*)(sp+=3);
      tp[-1]=tp[-2]==' '?' ':s;
    }
    printf("%s %s",t+(45-n*4)/3,m);
  }else
    printf("%*lu %s",n,u,m);
}
void showsize(const struct dir_entry far*pdir,const char*format,
	      const char*tail,int m,int n)
{
  if(pdir->attrib&FA_DIREC)
    printf(format,m+(flags&DIGIT3)," <DIR>  ");
  else
    print3(n,pdir->size,tail);
}
/* WindowsOEt@Cl[̕\Tu[`
 */
int putlfn(const unsigned far*lfn,int n)
{
  while(--n>=0){
    if(!*lfn)
      return 0;

    putucode(*(lfn++));
  }
  return n;
}
/* `FbNŤvZ
 */
char checksum(const char far*name)
{
  char sum=0;
  int i=11;
  while(--i>=0){
    asm ror sum,1;
    sum+=*(name++);
  }
  return sum;
}
/* t̕\
 */
void showdate(const struct dir_entry far*pdir)
{
  char*s;
  unsigned yh,m,dt=pdir->date;
  if(dt){
    yh=(dt>>9)+1980;
    m=(dt>>5)&0xF;
    dt&=0x1F;
    s=countryinfo.co_dtsep;

    if(!(flags&YEAR4))
      yh=yh%100;

    switch(countryinfo.co_date){
      case 0:  printf( "%2i%s%02i%s%02i",m,s,dt,s,yh); break;
      case 1:  printf("%02i%s%02i%s%02i",dt,s,m,s,yh); break;
      default: printf("%02i%s%02i%s%02i",yh,s,m,s,dt);
    }
    /* ̕\
     */
    yh=(dt=pdir->time)>>11;
    if(!(countryinfo.co_time&1)){
      if(yh<12)
	m='a';
      else{
	m='p';
	yh-=12;
      }
      if(!yh)
	yh=12;
    }
    printf("%3i%s%02i",yh,countryinfo.co_tmsep,(dt>>5)&0x3F);
    if(!(countryinfo.co_time&1))
      putchar(m);
  }else
    printf("%*s",16-(countryinfo.co_time&1)+(flags&YEAR4),"");
}
/* WindowsOl[EGg̗L̊mF
 */
#pragma option -O1 -Og -Oi -Ol -Om -Op -Ot
int islfn(const struct longname far*pdir)
{
  char sum=checksum(((const struct dir_entry far*)pdir)->name);
  FP_SEG(pdir)-=2;
  return pdir->attrib==0xF&&!(pdir->flags&0x80)
	 &&(pdir->checksum==sum||flags&IGNSUM);
}
/* t@CEXg̕\
 */
void showlist(int ndir)
{
  unsigned*dpa=NULL,*pdpa;
  const struct dir_entry far*pdir;
  char*eadata;
  unsigned long total;
  int found,founddir,j;
  /*
   * \Ώۂ̍i荞
   */
  pdir=dir=farrealloc(dir,(long)ndir<<5);
  for(total=0,found=founddir=0,j=ndir;*pdir->name&&--j>=0;FP_SEG(pdir)+=2)
    if(*pdir->name!=0xE5&&(pdir->attrib&attrib)==attrib&&!(pdir->attrib&mask)
       &&!fncmp(pdir->name)){
      if(flags&(LFN|EA))
	if(!islfn((void far*)pdir))
	  continue;

      if(!(dpa=realloc(dpa,(found+1)*sizeof*dpa)))
	error("Not enough memory to keep found directory entries");

      dpa[found++]=FP_SEG(pdir);

      if(pdir->attrib&FA_DIREC)
	++founddir;
      else
	total+=pdir->size;
    }

  nc=0;
  if(cand)
    free(cand);

  if(!found)
    error(cantfind);
  /*
   * fBNg̕\
   */
  if(!(flags&(TWOFIELDS|FQ|EA)))
    printf(" Directory of %s\n\n",truename);

  if((pathterm=truename+strlen(truename))[-1]!='\\')
    *(short*)(pathterm++)='\\';
  /*
   * wir2ea.cmdpf[^Et@C̃I[v (/EA)
   */
  if(flags&EA){
    if(!(eadata=tempnam(NULL,"wir")))
      error("Can't generate work file name");

    if(!freopen(eadata,"wt",stdout))
      error("Can't creat work file");
  }else
    /*
     * NCbN\[g (3̃fBA; /EAw莞̓XLbv)
     */
    if(sortopt)
      qsort(dpa,found,sizeof*dpa,cmp4sort);
  /*
   * \p[v
   */
  for(pdpa=dpa,j=found;--j>=0;){
    FP_SEG(pdir)=*(pdpa++);
    /*
     * t@C\pɉH
     * (/B /F /EA /N pAɏf͂ĂȂ)
     */
    {
      int i=namelen(pdir->ext,3);
      sprintf(pathterm,i?"%.*Fs.%.*Fs":"%.*Fs",
	      namelen(pdir->name,8),pdir->name,i,pdir->ext);
    }
    if(*pathterm==5)
      *pathterm=0xE5;

    if(flags&L)
      jstrlwr(truename,sizeof truename);
    /*
     * t@Ĉ݂̕\ (/B /F /EA)
     */
    if(flags&(TWOFIELDS|FQ|EA)){
      fputs(flags&(FQ|EA)?truename:pathterm,stdout);
    }else{
      if(flags&N){
	/*
	 * OS/2DIRR}hɎ\ (/N)
	 */
	struct{
	  unsigned	cdate,		/* Creation date	   */
			ctime,		/* Creation time	   */
			adate,		/* Last access date	   */
			atime,		/* Last access time	   */
			wdate,		/* Last write date	   */
			wtime;		/* Last write time	   */
	  unsigned long size,		/* File size		   */
			allocsize;	/* Allocated space	   */
	  unsigned	attrib;		/* File attributes	   */
	  unsigned long easize;		/* extended attribute size */
	}dosqfileinfo;

	showdate(pdir);
	showsize(pdir,"%*s","",12,11);

	dosqfileinfo.easize=0;
	asm{
	  push es; pusha; mov ax,5702h; mov bx,-1
	}
	_CX=sizeof(dosqfileinfo);
	asm{
	  mov dx,2; lea si,truename; lea di,dosqfileinfo; push ds; pop es;
	  int 21h; popa; pop es
	}
	print3(8,dosqfileinfo.easize<5?0:dosqfileinfo.easize,"");
	if(!islfn((void far*)pdir))
	  printf(" %s",pathterm);
      }else{
	/* DOSDIRR}hɎ\
	 */
	char name[13];

	sprintf(name,"%.8Fs %.3Fs",pdir->name,pdir->ext);
	if(flags&L)
	  jstrlwr(name,12);

	fputs(name,stdout);
	showsize(pdir,"%-*s"," ",13,11);
	showdate(pdir);
      }
    }
    /* WindowsOEt@Cl[̎擾ƕ\
     */
    {
      int i=1;
      char sum=checksum(pdir->name);
      const struct longname far*p=(void far*)pdir;
      do{
	FP_SEG(p)-=2;
	if(p->attrib!=0xF||(p->checksum!=sum&&!(flags&IGNSUM))
	   ||(p->flags&0xBF)!=i)
	  break;

	if(i++==1)
	  fputs(flags&(TWOFIELDS|FQ|EA)?"\t":"  ",stdout);

	if(putlfn(p->name1,5))
	  if(putlfn(p->name2,6))
	    putlfn(p->name3,2);
      }while(!(p->flags&0x40));
    }
    putchar('\n');
  }
  free(dpa);
  farfree(dir);

  if(!(flags&(TWOFIELDS|FQ|EA))){
    /*
     * oCg󂫗eʂ̕\
     * (/B /F /EÂꂩw肳ꂽꍇ)
     */
    struct dfree dfree;

    print3(11,found-founddir,"file(s)");
    print3(11,total,"bytes\n");
    print3(11,founddir,"dir(s) ");

    getdfree(drive+1,&dfree);
    print3(11,((unsigned long)dfree.df_avail<<dpb.sft)*dfree.df_bsec,
	   "bytes free\n");
  }else
    if(flags&EA){
      /*
       * wir2ea.cmdsobNOEhEvZXN (/EA)
       */
      static struct{
	unsigned Length,Related,FgBg,TraceOpt;
	char far*PgmTitle,far*PgmName,far*PgmInputs,far*TermQ;
      }StartData={
	sizeof StartData,SSF_RELATED_INDEPENDENT,SSF_FGBG_BACK,
	SSF_TRACEOPT_NONE,"wir2ea (started by wir)","CMD.EXE",NULL,NULL
      };

      if(!(StartData.PgmInputs=malloc(strlen(eadata)+18)))
	error("Not enough memory to start the process to set extended "
	      "attribute");

      sprintf((void*)StartData.PgmInputs,"/C wir2ea.cmd -d %s",eadata);
      free(eadata);
      asm{
	mov ah,64h; mov cx,636Ch; mov bx,25h; lea si,StartData; int 21h
      }
      if(_AX){
	fprintf(stderr,"Error executing child process. (Code=0x%02X)\n",_AX);
	exit(1);
      }
      puts("Now setting extended attribute in background process.");
    }
}
