#include<process.h>
#include<alloc.h>
#include<string.h>
#include"wir.h"

#pragma option -a-
struct bpb{
  char		jmp[3],sysid[8];
  unsigned	bps;
  char		spc;
  unsigned	rsv1;
  char		nfats;
  unsigned	ndir,nsects;
  char		id;
  unsigned	sfats,spt,nheads;
  unsigned long hidden,nsects2;
  char		drive,rsv2,bpbid;
  unsigned long serial;
  char		label[11],rsv3[8];
};

#pragma option -a -O1 -Og -Oi -Ol -Om -Op -Ot
void putvol(void)
{
  const struct dir_entry far*p;
  long i;

  for(p=dir,i=dpb.ndir;*p->name&&--i>=0;FP_SEG(p)+=2)
    if((p->attrib&~FA_ARCH)==FA_LABEL&&*p->name!=0xE5){
      printf("\n Volume in drive %c is %c%.10Fs\n",
	     drive+'A',*p->name==5?0xE5:*p->name,p->name+1);
      return;
    }
  printf("\n Volume in drive %c has no label\n",drive+'A');
}

#pragma option -O2
void getdpb(char*source,char*true)
{
#pragma option -a
  struct diskinfo{
    unsigned	  level;
    unsigned long serial;
    char	  label[11],fstype[8];
  }diskinfo;

  unsigned u;
  char cwd[]="X:.";
  _SI=(unsigned)source;
  if(_SI){
    _AL=*(char*)_SI;
    if(_AL)
      if(*(short*)(_SI+1)==':'){
	_SI=(unsigned)cwd;	/* hCugX:ĥ݂	   */
	*(char*)_SI=_AL;	/* wȂgX:.hƂ݂Ȃ */
      }
  }else
    _SI=(unsigned)(cwd+2);	/* source NULLȂg.hƂ݂Ȃ */

  asm{
	push	es
	mov	ah,60h	/* truename - canonicalize filename or path */
	mov	di,true
	push	ds
	pop	es
	int	21h
	pop	es
	jnc	isnet
  }
  error("Can't get truename");

isnet:
  if((_AL=*(char*)_DI)=='\\')
bad_drive:
    error("Invalid or network drive");

  drive=(_AL-='A');

  if(!(flags&DOCONLY)){
    asm{
	mov	ax,6900h	/* VAԍ⃉x擾̂ł͂Ȃ */
	mov	bl,drive	/* t@CVXeE^Cv̎擾ړI	    */
	inc	bl
	mov	bh,al
	lea	dx,diskinfo
	int	21h
	jc	getdpb	/* Error, but continue */
    }
    if(strncmp(diskinfo.fstype,"FAT",3)){
      fprintf(stderr,
	      "Not a FAT16 drive.  Filesystem type of this drive is %.11s\n",
	      diskinfo.fstype);
      exit(1);
    }
  }
getdpb:
  asm{
	push	ds
	mov	ah,32h	/* Get DOS drive parameter block for specific drive */
	mov	dl,drive
	inc	dl
	int	21h
	or	ax,ax
	mov	dx,ds
	pop	ds
	jz	bad_drive
  }
  _fmemcpy(&dpb,MK_FP(_DX,_BX),sizeof dpb);
  if(dpb.maxcl<=0xFF6)
    error("This program does not support FAT12 drive");

  u=(unsigned short)((((unsigned long)dpb.ndir<<5)+(dpb.bps-1))/dpb.bps);
  if(!(dir=farmalloc(u*dpb.bps)))
    error("Not enough memory to load root directory");

  if(farabsread(dpb.dir,u,dir)){
    fprintf(stderr,"Can't load root directory. (Sector=%u-%u)\n",
	    dpb.dir,dpb.dir+u-1);
    exit(1);
  }
  if(!(flags&(TWOFIELDS|FQ|EA))){
    struct bpb*bpbp;

    putvol();
    if(!(bpbp=malloc(dpb.bps)))
      error("Not enough memory to get bios parameter block");

    if(farabsread(0,1,bpbp))
      error("Can't load bios parameter block");

    if(bpbp->bpbid==0x29)
      printf(" Volume Serial Number is %Fp\n",bpbp->serial);

    free(bpbp);
  }
}
