/********************************************************copyrite.xic***/
/*                                                                     */
/*   Licensed Materials - Property of IBM                              */
/*                                                                     */
/*   This product contains "Restricted Materials of IBM":              */
/*      Program Number:   5798RXW                                      */
/*      Program Name:     IBM TCP/IP Version 1.2 for OS/2              */
/*   (C) Copyright IBM Corporation. 1990, 1993.                        */
/*                                                                     */
/*   All rights reserved.                                              */
/*                                                                     */
/*   US Government Users Restricted Rights -                           */
/*   Use, duplication or disclosure restricted by GSA ADP Schedule     */
/*   Contract with IBM Corp.                                           */
/*                                                                     */
/*   See IBM Copyright Instructions.                                   */
/*                                                                     */
/*   SENDFILE uses TCP to transfer a file to the TCP server, SELECTS.  */
/*                                                                     */
/********************************************************copyrite.xic***/
/*  $Author:   Build_Coordinator  $                                                     */
/*  $Revision:   1.0  $                                                     */
/*  $Modtime:   30 Jan 1993 14:25:14  $                                                     */
/*                                                                     */
/*  $Header:   L:/samples/sockets/sendfile.c_v   1.0   30 Jan 1993 14:29:42   Build_Coordinator  $                                                     */
/*                                                                     */
/*  $Log:   L:/samples/sockets/sendfile.c_v  $                                                     */
 * 
 *    Rev 1.0   30 Jan 1993 14:29:42   Build_Coordinator
 * Initial revision.
/*                                                                     */
/*                                                                     */
/***********************************************************************/
/*
 * Include Files.
 */
#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>

#include <sys\tcptypes.h>
#include <netinet\in.h>
#include <sys\socket.h>
#include <netdb.h>


char buf[16385];

/*
 * Client Main.
 */
main(argc, argv)
int argc;
char **argv;
{
    unsigned short port;       /* port client will connect to              */
    struct hostent *hostnm;    /* server host name information             */
    struct sockaddr_in server; /* server address                           */
    int s;                     /* client socket                            */
    int fh;
    int i;
    int eofbyte = 0x1a1a;

    /*
     * Check Arguments Passed. Should be hostname and port.
     */
    if (argc != 4)
    {
        fprintf(stderr, "Usage: %s hostname port file\n", argv[0]);
        exit(1);
    }

    /*
     * Check if INET running.
     */
    if (sock_init())
    {
       printf("TCPIP is not running!\n");
       exit(1);
    }

    /*
     * The host name is the first argument. Get the server address.
     */
    hostnm = gethostbyname(argv[1]);
    if (hostnm == (struct hostent *) 0)
    {
        fprintf(stderr, "Gethostbyname failed\n");
        exit(2);
    }

    /*
     * The port is the second argument.
     */
    port = (unsigned short) atoi(argv[2]);

    /*
     * Put the server information into the server structure.
     * The port must be put into network byte order.
     */
    server.sin_family      = AF_INET;
    server.sin_port        = htons(port);
    server.sin_addr.s_addr = *((unsigned long *)hostnm->h_addr);

    /*
     * Get a stream socket.
     */
    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
        perror("Socket()");
        exit(3);
    }

    /*
     * Connect to the server.
     */
    if (connect(s,(struct sockaddr _far *) &server, sizeof(server)) < 0)
    {
        perror("Connect()");
        exit(4);
    }

    fh = open(argv[3], O_BINARY | O_RDONLY);

    while ((i=read(fh, buf, sizeof(buf))) > 0) {
       int count = 0, rc;

       while (i) {
          if((rc = send(s, buf+count, i, 0)) <= 0) {
             printf("send: rc=%d\n", rc);
             exit(1);
          } /* endif */
          count += rc;
          i -= rc;
       } /* endwhile */
    } /* endwhile */
    send(s,&eofbyte,1,0);

    /*
     * Close the socket.
     */
    soclose(s);

    printf("Client Ended Successfully\n");
    return(0);

}


